/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.security.rolestrategy;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;

public abstract class AbstractOwnershipRoleMacro
extends RoleMacroExtension {
    public static final String NO_SID_SUFFIX = "NoSid";
    protected static final String AUTHENTICATED_SID = "authenticated";

    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="Part of other plugin API")
    public boolean IsApplicable(RoleType roleType) {
        switch (roleType) {
            case Project: {
                return true;
            }
            case Slave: {
                return true;
            }
        }
        return false;
    }

    public static OwnershipDescription getOwnership(RoleType type, AccessControlled item) {
        switch (type) {
            case Project: {
                if (!(item instanceof Item)) break;
                AbstractOwnershipHelper<AccessControlled> helper = OwnershipHelperLocator.locate(item);
                return helper != null ? helper.getOwnershipDescription(item) : OwnershipDescription.DISABLED_DESCR;
            }
            case Slave: {
                Computer comp;
                Node node;
                if (!(item instanceof Computer) || (node = (comp = (Computer)item).getNode()) == null) break;
                return NodeOwnerHelper.Instance.getOwnershipDescription(node);
            }
        }
        return OwnershipDescription.DISABLED_DESCR;
    }

    public static boolean hasPermission(@CheckForNull User user, RoleType type, AccessControlled item, Macro macro, boolean acceptSecondaryOwners) {
        return user != null && AbstractOwnershipRoleMacro.getOwnership(type, item).isOwner(user, acceptSecondaryOwners);
    }
}

