/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import hudson.model.User;
import hudson.security.Permission;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ownership.model.OwnershipInfo;

public abstract class AbstractOwnershipHelper<TObjectType>
implements IOwnershipHelper<TObjectType> {
    @Override
    @Nonnull
    public final String getDisplayName(@CheckForNull User usr) {
        return UserStringFormatter.format(usr);
    }

    @Override
    @CheckForNull
    public final String getOwnerEmail(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return UserStringFormatter.formatEmail(descr.getPrimaryOwner());
    }

    @Override
    @Nonnull
    public final String getOwnerLongString(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return descr.isOwnershipEnabled() ? UserStringFormatter.format(descr.getPrimaryOwner()) : "N/A";
    }

    @Override
    @Nonnull
    public final String getOwner(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return descr.isOwnershipEnabled() ? UserStringFormatter.formatShort(descr.getPrimaryOwnerId()) : "N/A";
    }

    @Override
    public final boolean isOwnerExists(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return descr.isOwnershipEnabled() ? descr.hasPrimaryOwner() : false;
    }

    @Override
    public Collection<User> getPossibleOwners(TObjectType item) {
        return Collections.emptyList();
    }

    public boolean isDisplayOwnershipSummaryBox(@Nonnull TObjectType item) {
        if (!this.getOwnershipDescription(item).isOwnershipEnabled()) {
            return !OwnershipPlugin.getInstance().getConfiguration().getDisplayOptions().isHideOwnershipIfNoData();
        }
        return true;
    }

    @Nonnull
    public abstract OwnershipInfo getOwnershipInfo(@Nonnull TObjectType var1);

    @Nonnull
    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    public boolean hasLocallyDefinedOwnership(@Nonnull TObjectType item) {
        return false;
    }
}

