/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class OwnershipDescriptionHelper {
    private OwnershipDescriptionHelper() {
    }

    @Nonnull
    @Deprecated
    public static String getOwnerID(@Nonnull OwnershipDescription descr) {
        return OwnershipDescriptionHelper.getPrimaryOwnerId(descr);
    }

    @Nonnull
    public static String getPrimaryOwnerId(@Nonnull OwnershipDescription descr) {
        return descr.getPrimaryOwnerId();
    }

    @Nonnull
    @Deprecated
    public static String getOwnerEmail(@Nonnull OwnershipDescription descr) {
        return OwnershipDescriptionHelper.getPrimaryOwnerEmail(descr);
    }

    @Nonnull
    public static String getPrimaryOwnerEmail(@Nonnull OwnershipDescription descr) {
        String ownerEmail = UserStringFormatter.formatEmail(descr.getPrimaryOwnerId());
        return ownerEmail != null ? ownerEmail : "";
    }

    @Nonnull
    public static Set<String> getSecondaryOwnerIds(@Nonnull OwnershipDescription descr, boolean includeOwner) {
        TreeSet<String> res = new TreeSet<String>();
        if (includeOwner) {
            res.add(OwnershipDescriptionHelper.getPrimaryOwnerId(descr));
        }
        for (String userId : descr.getSecondaryOwnerIds()) {
            res.add(userId);
        }
        return res;
    }

    @Deprecated
    @Nonnull
    public static String getCoOwnerIDs(@Nonnull OwnershipDescription descr) {
        return OwnershipDescriptionHelper.getAllOwnerEmailsString(descr);
    }

    @Nonnull
    public static String getAllOwnerIdsString(@Nonnull OwnershipDescription descr) {
        StringBuilder coowners = new StringBuilder();
        for (String userId : OwnershipDescriptionHelper.getSecondaryOwnerIds(descr, true)) {
            if (coowners.length() != 0) {
                coowners.append(",");
            }
            coowners.append(userId);
        }
        return coowners.toString();
    }

    public static Set<String> getSecondaryOwnerEmails(@Nonnull OwnershipDescription descr, boolean includeOwner) {
        TreeSet<String> res = new TreeSet<String>();
        if (includeOwner) {
            res.add(OwnershipDescriptionHelper.getOwnerEmail(descr));
        }
        for (String userId : descr.getSecondaryOwnerIds()) {
            String coownerEmail = UserStringFormatter.formatEmail(userId);
            if (coownerEmail == null) continue;
            res.add(coownerEmail);
        }
        return res;
    }

    public static String getAllOwnerEmailsString(@Nonnull OwnershipDescription descr) {
        StringBuilder coownerEmails = new StringBuilder();
        for (String coownerEmail : OwnershipDescriptionHelper.getSecondaryOwnerEmails(descr, true)) {
            if (coownerEmails.length() != 0) {
                coownerEmails.append(",");
            }
            coownerEmails.append(coownerEmail);
        }
        return coownerEmails.toString();
    }
}

