/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.IUserFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.UserComparator;
import hudson.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UserCollectionFilter {
    @Nonnull
    public static Collection<User> filterUsers(@Nonnull Collection<User> input, boolean enableSort, IUserFilter ... filters) {
        UserComparator comparator = new UserComparator();
        LinkedList userList = new LinkedList(User.getAll());
        if (enableSort) {
            Collections.sort(userList, comparator);
        }
        ArrayList<User> res = new ArrayList<User>();
        for (User user : userList) {
            if (user == null) continue;
            boolean meets = true;
            for (int i = 0; meets && i < filters.length; ++i) {
                meets = filters[i].filter(user);
            }
            if (!meets) continue;
            res.add(user);
        }
        return res;
    }
}

