/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util.ui;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPluginConfiguration;
import com.synopsys.arc.jenkins.plugins.ownership.util.HTMLFormatter;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.util.mail.OwnershipMailHelper;

public abstract class OwnershipLayoutFormatter<TObjectType> {
    @Nonnull
    public abstract String formatUser(@Nonnull TObjectType var1, @Nonnull String var2);

    @Nonnull
    public String formatPrimaryOwner(@Nonnull TObjectType item, @Nonnull String userId) {
        return this.formatOwner(item, userId);
    }

    @Deprecated
    @Nonnull
    public String formatOwner(@Nonnull TObjectType item, @Nonnull String userId) {
        return this.formatUser(item, userId);
    }

    @Nonnull
    public String formatSecondaryOwner(@Nonnull TObjectType item, @Nonnull String userId) {
        return this.formatCoOwner(item, userId);
    }

    @Deprecated
    @Nonnull
    public String formatCoOwner(@Nonnull TObjectType item, @Nonnull String userId) {
        return this.formatUser(item, userId);
    }

    public abstract String formatContactOwnersLink(@Nonnull TObjectType var1, IOwnershipHelper var2);

    public abstract String formatContactAdminsLink(@Nonnull TObjectType var1, IOwnershipHelper var2);

    public static class DefaultJobFormatter<TObjectType>
    extends OwnershipLayoutFormatter<TObjectType> {
        @Override
        public String formatUser(TObjectType item, String userId) {
            String userEmail;
            StringBuilder rawHtmlBuilder = new StringBuilder();
            rawHtmlBuilder.append(HTMLFormatter.formatUserURI(userId, true));
            if (!OwnershipPluginConfiguration.get().getMailOptions().isHideOwnerAndCoOwnerEmails() && (userEmail = HTMLFormatter.formatEmailURI(userId)) != null) {
                rawHtmlBuilder.append(' ');
                rawHtmlBuilder.append(userEmail);
            }
            return rawHtmlBuilder.toString();
        }

        @Override
        public String formatContactOwnersLink(TObjectType item, IOwnershipHelper helper) {
            return OwnershipMailHelper.getContactOwnersMailToURL(item, helper);
        }

        @Override
        public String formatContactAdminsLink(TObjectType item, IOwnershipHelper helper) {
            return OwnershipMailHelper.getContactAdminsMailToURL(item, helper);
        }
    }
}

