/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.wrappers;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.OwnershipDescriptionHelper;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension(optional=true)
public class OwnershipTokenMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "OWNERSHIP";
    @DataBoundTokenMacro.Parameter
    public String var;

    public boolean acceptsMacroName(String string) {
        return string.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> ab, TaskListener tl, String string) throws MacroEvaluationException, IOException, InterruptedException {
        OwnershipFunction func;
        if (this.var == null) {
            throw new MacroEvaluationException("OWNERSHIP macro requires the 'var' parameter");
        }
        try {
            func = OwnershipFunction.valueOf(this.var);
        }
        catch (IllegalArgumentException ex) {
            throw new MacroEvaluationException("OWNERSHIP macro does not support var=" + this.var);
        }
        OwnershipDescription job = JobOwnerHelper.Instance.getOwnershipDescription((Job<?, ?>)ab.getProject());
        Node node = ab.getBuiltOn();
        OwnershipDescription nodeDescription = node != null ? NodeOwnerHelper.Instance.getOwnershipDescription(node) : OwnershipDescription.DISABLED_DESCR;
        return func.evaluate(job, nodeDescription);
    }

    private static enum OwnershipFunction {
        JOB_OWNER(true),
        JOB_OWNER_EMAIL(true),
        JOB_COOWNERS(true),
        JOB_COOWNERS_EMAILS(true),
        NODE_OWNER(false),
        NODE_OWNER_EMAIL(false),
        NODE_COOWNERS(false),
        NODE_COOWNERS_EMAILS(false);

        private final boolean isJob;

        private OwnershipFunction(boolean isJob) {
            this.isJob = isJob;
        }

        public boolean isJobFunction() {
            return this.isJob;
        }

        public boolean isNodeFunction() {
            return !this.isJob;
        }

        public String evaluate(OwnershipDescription job, OwnershipDescription node) throws IOException {
            if (this.isJobFunction() && !job.isOwnershipEnabled()) {
                throw new IOException("Job Ownership is disabled");
            }
            if (this.isNodeFunction() && !node.isOwnershipEnabled()) {
                throw new IOException("Node Ownership is disabled");
            }
            switch (this) {
                case JOB_OWNER: {
                    return OwnershipDescriptionHelper.getPrimaryOwnerId(job);
                }
                case JOB_OWNER_EMAIL: {
                    return OwnershipDescriptionHelper.getPrimaryOwnerEmail(job);
                }
                case JOB_COOWNERS: {
                    return OwnershipDescriptionHelper.getAllOwnerIdsString(job);
                }
                case JOB_COOWNERS_EMAILS: {
                    return OwnershipDescriptionHelper.getAllOwnerEmailsString(job);
                }
                case NODE_OWNER: {
                    return OwnershipDescriptionHelper.getPrimaryOwnerId(node);
                }
                case NODE_OWNER_EMAIL: {
                    return OwnershipDescriptionHelper.getPrimaryOwnerEmail(node);
                }
                case NODE_COOWNERS: {
                    return OwnershipDescriptionHelper.getAllOwnerIdsString(node);
                }
                case NODE_COOWNERS_EMAILS: {
                    return OwnershipDescriptionHelper.getAllOwnerEmailsString(node);
                }
            }
            throw new IOException((Object)((Object)this) + " ownership function is not implemented");
        }
    }
}

