/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.integrations.securityinspector;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

class OwnerFilter {
    private static final Logger LOGGER = Logger.getLogger(OwnerFilter.class.getName());
    @CheckForNull
    private final String includeRegex;
    @CheckForNull
    private final Pattern includePattern;
    @CheckForNull
    private final String report4folder;

    public OwnerFilter() {
        this.includeRegex = null;
        this.includePattern = null;
        this.report4folder = null;
    }

    @Restricted(value={NoExternalUse.class})
    public OwnerFilter(@Nonnull StaplerRequest req) throws Descriptor.FormException, ServletException {
        if (req.getParameter("useincluderegex") != null) {
            this.includeRegex = Util.nullify((String)req.getParameter("_.includeRegex"));
            if (this.includeRegex == null) {
                this.includePattern = null;
            } else {
                try {
                    this.includePattern = Pattern.compile(this.includeRegex);
                }
                catch (PatternSyntaxException ex) {
                    throw new Descriptor.FormException((Throwable)ex, "includeRegex");
                }
            }
        } else {
            this.includeRegex = null;
            this.includePattern = null;
        }
        this.report4folder = req.getParameter("usefolder") != null ? req.getParameter("selectedFolder") : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public List<TopLevelItem> doFilter(User owner) {
        ArrayList<Object> allItems;
        Collection<TopLevelItem> items;
        Jenkins jenkins = Jenkins.getActiveInstance();
        if (this.report4folder != null) {
            TopLevelItem folder = jenkins.getItem(this.report4folder);
            if (!(folder instanceof ItemGroup)) {
                LOGGER.log(Level.WARNING, this.report4folder + " is not an ItemGroup");
                return Collections.emptyList();
            }
            items = ((ItemGroup)folder).getItems();
            allItems = new ArrayList<Object>(items.size());
            for (Item item : items) {
                allItems.add(item);
            }
            allItems.add(folder);
        } else {
            allItems = jenkins.getAllItems(Item.class);
        }
        items = new ArrayList();
        Iterator iterator = allItems.iterator();
        while (iterator.hasNext()) {
            AbstractOwnershipHelper<Item> abstractOwnershipHelper;
            Item item = (Item)iterator.next();
            if (!(item instanceof TopLevelItem) || (abstractOwnershipHelper = OwnershipHelperLocator.locate(item)) == null) continue;
            String itemName = item.getFullName();
            OwnershipDescription ownershipDescription = abstractOwnershipHelper.getOwnershipDescription(item);
            if (!ownershipDescription.isOwnershipEnabled() || !ownershipDescription.isOwner(owner, true) || this.includePattern != null && !this.includePattern.matcher(itemName).matches()) continue;
            items.add((TopLevelItem)item);
        }
        return items;
    }

    @CheckForNull
    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    @CheckForNull
    public String getIncludeRegex() {
        return this.includeRegex;
    }
}

