/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.integrations.securityinspector;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.View;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.plugins.ownership.integrations.securityinspector.OwnerFilter;
import org.jenkinsci.plugins.securityinspector.Messages;
import org.jenkinsci.plugins.securityinspector.SecurityInspectorAction;
import org.jenkinsci.plugins.securityinspector.UserContext;
import org.jenkinsci.plugins.securityinspector.UserContextCache;
import org.jenkinsci.plugins.securityinspector.impl.users.UserReportBuilder;
import org.jenkinsci.plugins.securityinspector.model.PermissionReport;
import org.jenkinsci.plugins.securityinspector.model.SecurityInspectorReport;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;

@Extension(optional=true)
public class PermissionsForOwnerReportBuilder
extends UserReportBuilder {
    public String getIcon() {
        return "fingerprint.png";
    }

    public String getIndex() {
        return "items-for-owner";
    }

    public String getDisplayName() {
        return "Single any owner, multiple items";
    }

    public String getDescription() {
        return "Display job permissions for the specified owner";
    }

    public void processParameters(StaplerRequest req) throws Descriptor.FormException, ServletException {
        String regex = req.getParameter("_.includeRegex");
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException exception) {
            throw new Descriptor.FormException((Throwable)exception, "includeRegex");
        }
        String selectedItem = req.getParameter("selectedOwner");
        OwnerFilter filters = new OwnerFilter(req);
        User owner = User.get((String)selectedItem);
        List<TopLevelItem> selectedJobs = filters.doFilter(owner);
        UserContextCache.updateSearchCache(selectedJobs, null, null, (String)selectedItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityInspectorReport getReport() {
        ReportImpl report;
        Authentication auth;
        Set<TopLevelItem> items = this.getRequestedJobs();
        User user = this.getRequestedUser();
        try {
            auth = user.impersonate();
        }
        catch (UsernameNotFoundException ex) {
            return new ReportImpl(user);
        }
        SecurityContext initialContext = null;
        try {
            initialContext = ACL.impersonate((Authentication)auth);
            report = ReportImpl.createReport(items, user);
        }
        finally {
            if (initialContext != null) {
                SecurityContextHolder.setContext((SecurityContext)initialContext);
            }
        }
        return report;
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<TopLevelItem> getRequestedJobs() throws HttpResponses.HttpResponseException {
        UserContext context = UserContextCache.getInstance().get(SecurityInspectorAction.getSessionId());
        if (context == null) {
            throw HttpResponses.error((int)404, (String)"Context has not been found");
        }
        List selectedJobs = context.getJobs();
        if (selectedJobs == null) {
            throw HttpResponses.error((int)500, (String)"The retrieved context does not contain job filter settings");
        }
        HashSet<TopLevelItem> res = new HashSet<TopLevelItem>(selectedJobs.size());
        for (TopLevelItem item : selectedJobs) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    public static class ReportImpl
    extends PermissionReport<TopLevelItem, Boolean> {
        @Nonnull
        final User user4report;

        ReportImpl(@Nonnull User user) {
            this.user4report = user;
        }

        public String getReportTargetName() {
            return this.user4report.getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean getEntryReport(TopLevelItem column, Permission item) {
            Authentication auth;
            try {
                auth = this.user4report.impersonate();
            }
            catch (UsernameNotFoundException ex) {
                return Boolean.FALSE;
            }
            SecurityContext initialContext = null;
            Item i = Jenkins.getActiveInstance().getItemByFullName(column.getFullName());
            if (i == null) {
                return Boolean.FALSE;
            }
            try {
                initialContext = ACL.impersonate((Authentication)auth);
                Boolean bl = i.hasPermission(item);
                return bl;
            }
            finally {
                if (initialContext != null) {
                    SecurityContextHolder.setContext((SecurityContext)initialContext);
                }
            }
        }

        public final void generateReport(@Nonnull Set<TopLevelItem> rows) {
            HashSet groups = new HashSet(PermissionGroup.getAll());
            groups.remove(PermissionGroup.get(Permission.class));
            groups.remove(PermissionGroup.get(Jenkins.class));
            groups.remove(PermissionGroup.get(Computer.class));
            groups.remove(PermissionGroup.get(View.class));
            super.generateReport(rows, groups);
        }

        @Nonnull
        public static ReportImpl createReport(@Nonnull Set<TopLevelItem> rows, @Nonnull User user) {
            ReportImpl report = new ReportImpl(user);
            report.generateReport(rows);
            return report;
        }

        public String getRowColumnHeader() {
            return Messages.JobReport_RowColumnHeader();
        }

        public String getRowTitle(TopLevelItem row) {
            return row.getFullDisplayName();
        }

        public boolean isEntryReportOk(TopLevelItem row, Permission item, Boolean report) {
            return report != null ? report : false;
        }
    }
}

