/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.model.folders;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.extensions.ItemOwnershipPolicy;
import hudson.Extension;
import hudson.Plugin;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ownership.model.folders.FolderOwnershipHelper;

@Extension(optional=true)
public class FolderItemListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(FolderItemListener.class.getName());

    public void onCopied(Item src, Item item) {
        if (!this.isFoldersPluginEnabled()) {
            return;
        }
        OwnershipDescription d = this.getPolicy().onCopied(src, item);
        this.modifyOwnership(item, d);
    }

    public void onCreated(Item item) {
        if (!this.isFoldersPluginEnabled()) {
            return;
        }
        OwnershipDescription d = this.getPolicy().onCreated(item);
        this.modifyOwnership(item, d);
    }

    private ItemOwnershipPolicy getPolicy() {
        return OwnershipPlugin.getInstance().getConfiguration().getItemOwnershipPolicy();
    }

    private boolean isFoldersPluginEnabled() {
        Plugin plugin = Jenkins.getActiveInstance().getPlugin("cloudbees-folder");
        return plugin != null && plugin.getWrapper().isActive();
    }

    private void modifyOwnership(Item item, OwnershipDescription ownership) {
        if (item instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)item;
            try {
                FolderOwnershipHelper.setOwnership(folder, ownership);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Cannot change ownership of {0} to [{1}]. {2}", new Object[]{item, ownership, ex});
            }
        }
    }
}

