/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.model.folders;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.ItemOwnershipAction;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.util.ui.OwnershipLayoutFormatter;
import hudson.model.Descriptor;
import hudson.security.Permission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ownership.model.folders.FolderOwnershipHelper;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class FolderOwnershipAction
extends ItemOwnershipAction<AbstractFolder<?>> {
    private static final OwnershipLayoutFormatter<AbstractFolder<?>> DEFAULT_FOLDER_FORMATTER = new OwnershipLayoutFormatter.DefaultJobFormatter();

    public FolderOwnershipAction(@Nonnull AbstractFolder<?> folder) {
        super(folder);
    }

    @Override
    public Permission getOwnerPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public Permission getProjectSpecificPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public boolean actionIsAvailable() {
        return ((AbstractFolder)this.getDescribedItem()).hasPermission(OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP);
    }

    @Override
    public IOwnershipHelper<AbstractFolder<?>> helper() {
        return FolderOwnershipHelper.getInstance();
    }

    public OwnershipLayoutFormatter<AbstractFolder<?>> getLayoutFormatter() {
        return DEFAULT_FOLDER_FORMATTER;
    }

    public HttpResponse doOwnersSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        ((AbstractFolder)this.getDescribedItem()).checkPermission(OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP);
        JSONObject jsonOwnership = req.getSubmittedForm().getJSONObject("owners");
        OwnershipDescription descr = OwnershipDescription.parseJSON(jsonOwnership);
        FolderOwnershipHelper.setOwnership((AbstractFolder)this.getDescribedItem(), descr);
        return HttpResponses.redirectViaContextPath((String)((AbstractFolder)this.getDescribedItem()).getUrl());
    }
}

