/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.model.folders;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPluginConfiguration;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.AccessRightsFilter;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.jenkinsci.plugins.ownership.model.OwnershipInfo;
import org.jenkinsci.plugins.ownership.model.folders.FolderOwnershipDescriptionSource;
import org.jenkinsci.plugins.ownership.model.folders.FolderOwnershipProperty;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class FolderOwnershipHelper
extends AbstractOwnershipHelper<AbstractFolder<?>> {
    static final FolderOwnershipHelper INSTANCE = new FolderOwnershipHelper();

    @Nonnull
    public static FolderOwnershipHelper getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public static FolderOwnershipProperty getOwnerProperty(@Nonnull AbstractFolder<?> folder) {
        FolderOwnershipProperty prop = (FolderOwnershipProperty)folder.getProperties().get(FolderOwnershipProperty.class);
        return prop != null ? prop : null;
    }

    @Override
    public String getItemTypeName(AbstractFolder<?> item) {
        return "folder";
    }

    @Override
    public String getItemDisplayName(AbstractFolder<?> item) {
        return item.getDisplayName();
    }

    @Override
    public String getItemURL(AbstractFolder<?> item) {
        return item.getUrl();
    }

    @Override
    public OwnershipDescription getOwnershipDescription(AbstractFolder<?> item) {
        return this.getOwnershipInfo(item).getDescription();
    }

    @Override
    @Nonnull
    public Permission getRequiredPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public boolean hasLocallyDefinedOwnership(@Nonnull AbstractFolder<?> folder) {
        return FolderOwnershipHelper.getOwnerProperty(folder) != null;
    }

    @Override
    public OwnershipInfo getOwnershipInfo(AbstractFolder<?> item) {
        OwnershipDescription d;
        if (item == null) {
            return OwnershipInfo.DISABLED_INFO;
        }
        FolderOwnershipProperty prop = FolderOwnershipHelper.getOwnerProperty(item);
        if (prop != null && (d = prop.getOwnership()).isOwnershipEnabled()) {
            return new OwnershipInfo(prop.getOwnership(), new FolderOwnershipDescriptionSource(item));
        }
        if (!OwnershipPluginConfiguration.get().getInheritanceOptions().isBlockInheritanceFromItemGroups()) {
            ItemGroup parent = item.getParent();
            AbstractOwnershipHelper<ItemGroup> located = OwnershipHelperLocator.locate(parent);
            while (located != null) {
                OwnershipInfo fromParent = located.getOwnershipInfo(parent);
                if (fromParent.getDescription().isOwnershipEnabled()) {
                    return fromParent;
                }
                if (parent instanceof Item) {
                    Item parentItem = (Item)parent;
                    parent = parentItem.getParent();
                    located = OwnershipHelperLocator.locate(parent);
                    continue;
                }
                located = null;
            }
        }
        return OwnershipInfo.DISABLED_INFO;
    }

    @Override
    public Collection<User> getPossibleOwners(AbstractFolder<?> item) {
        if (OwnershipPlugin.getInstance().isRequiresConfigureRights()) {
            AccessRightsFilter filter = new AccessRightsFilter((AccessControlled)item, AbstractFolder.CONFIGURE);
            return UserCollectionFilter.filterUsers(User.getAll(), true, filter);
        }
        return User.getAll();
    }

    public static void setOwnership(@Nonnull AbstractFolder<?> folder, @CheckForNull OwnershipDescription descr) throws IOException {
        FolderOwnershipProperty prop = FolderOwnershipHelper.getOwnerProperty(folder);
        if (prop == null) {
            prop = new FolderOwnershipProperty(descr);
            folder.addProperty((AbstractFolderProperty)prop);
        } else {
            prop.setOwnershipDescription(descr);
        }
    }

    @Extension(optional=true)
    @Restricted(value={NoExternalUse.class})
    public static class LocatorImpl
    extends OwnershipHelperLocator<AbstractFolder<?>> {
        @Override
        public AbstractOwnershipHelper<AbstractFolder<?>> findHelper(Object item) {
            if (item instanceof AbstractFolder) {
                return INSTANCE;
            }
            return null;
        }
    }
}

