/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.model.runs;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.ItemOwnershipAction;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.util.ui.OwnershipLayoutFormatter;
import com.synopsys.arc.jenkins.plugins.ownership.wrappers.OwnershipBuildWrapper;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.security.Permission;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.runs.RunOwnershipHelper;
import org.jenkinsci.plugins.ownership.util.environment.EnvSetupOptions;

public class RunOwnershipAction
extends ItemOwnershipAction<Run>
implements EnvironmentContributingAction {
    public RunOwnershipAction(@Nonnull Run describedItem) {
        super(describedItem);
    }

    @Override
    public Permission getOwnerPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public Permission getProjectSpecificPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public boolean actionIsAvailable() {
        return false;
    }

    @Override
    public IOwnershipHelper<Run> helper() {
        return RunOwnershipHelper.getInstance();
    }

    public OwnershipLayoutFormatter<Run> getLayoutFormatter() {
        return OwnershipPlugin.getInstance().getOwnershipLayoutFormatterProvider().getLayoutFormatter((Run)this.getDescribedItem());
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        BuildableItemWithBuildWrappers prj;
        OwnershipBuildWrapper wrapper;
        Job parent;
        boolean injectNodeOwnership = false;
        boolean injectJobOwnership = false;
        EnvSetupOptions globalEnvSetupOptions = OwnershipPlugin.getInstance().getConfiguration().getGlobalEnvSetupOptions();
        if (globalEnvSetupOptions != null) {
            injectNodeOwnership |= globalEnvSetupOptions.isInjectNodeOwnership();
            injectJobOwnership |= globalEnvSetupOptions.isInjectJobOwnership();
        }
        if ((parent = build.getParent()) instanceof BuildableItemWithBuildWrappers && (wrapper = (OwnershipBuildWrapper)(prj = (BuildableItemWithBuildWrappers)parent).getBuildWrappersList().get(OwnershipBuildWrapper.class)) != null) {
            injectJobOwnership |= wrapper.isInjectJobOwnership();
            injectNodeOwnership |= wrapper.isInjectNodeOwnership();
        }
        RunOwnershipHelper.setUp(build, (Map<String, String>)env, null, injectJobOwnership, injectNodeOwnership);
    }
}

