/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.model.runs;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.OwnerNodeProperty;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Run;
import hudson.security.Permission;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.model.OwnershipHelperLocator;
import org.jenkinsci.plugins.ownership.model.OwnershipInfo;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class RunOwnershipHelper
extends AbstractOwnershipHelper<Run> {
    private static final RunOwnershipHelper INSTANCE = new RunOwnershipHelper();

    public static RunOwnershipHelper getInstance() {
        return INSTANCE;
    }

    @Override
    public String getItemTypeName(Run item) {
        return "run";
    }

    @Override
    public String getItemDisplayName(Run item) {
        return item.getFullDisplayName();
    }

    @Override
    public String getItemURL(Run item) {
        return item.getUrl();
    }

    @Override
    public OwnershipDescription getOwnershipDescription(Run item) {
        return JobOwnerHelper.Instance.getOwnershipDescription(item.getParent());
    }

    @Override
    public OwnershipInfo getOwnershipInfo(Run item) {
        return JobOwnerHelper.Instance.getOwnershipInfo(item.getParent());
    }

    @Override
    public Permission getRequiredPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    public static void setUp(@Nonnull AbstractBuild build, @Nonnull Map<String, String> target, @CheckForNull BuildListener listener, boolean injectJobOwnership, boolean injectNodeOwnership) {
        if (injectJobOwnership) {
            OwnershipDescription descr = JobOwnerHelper.Instance.getOwnershipDescription(build.getParent());
            RunOwnershipHelper.getVariables(descr, target, "JOB");
        }
        if (injectNodeOwnership) {
            Node node = build.getBuiltOn();
            if (node == null) {
                assert (false) : "Cannot retrieve node of the build. Probably, it has been deleted";
                if (listener != null) {
                    listener.error("Cannot retrieve node of the build. Probably, it has been deleted. Variables will be ignored.");
                }
                return;
            }
            OwnerNodeProperty prop = (OwnerNodeProperty)node.getNodeProperties().get(OwnerNodeProperty.class);
            OwnershipDescription descr = prop != null ? prop.getOwnership() : OwnershipDescription.DISABLED_DESCR;
            RunOwnershipHelper.getVariables(descr, target, "NODE");
        }
    }

    private static void getVariables(OwnershipDescription descr, Map<String, String> target, String prefix) {
        target.put(prefix + "_OWNER", descr.hasPrimaryOwner() ? descr.getPrimaryOwnerId() : "");
        String ownerEmail = UserStringFormatter.formatEmail(descr.getPrimaryOwnerId());
        target.put(prefix + "_OWNER_EMAIL", ownerEmail != null ? ownerEmail : "");
        StringBuilder coowners = new StringBuilder(target.get(prefix + "_OWNER"));
        StringBuilder coownerEmails = new StringBuilder(target.get(prefix + "_OWNER_EMAIL"));
        for (String userId : descr.getCoownersIds()) {
            if (coowners.length() != 0) {
                coowners.append(",");
            }
            coowners.append(userId);
            String coownerEmail = UserStringFormatter.formatEmail(userId);
            if (coownerEmail == null) continue;
            if (coownerEmails.length() != 0) {
                coownerEmails.append(",");
            }
            coownerEmails.append(coownerEmail);
        }
        target.put(prefix + "_COOWNERS", coowners.toString());
        target.put(prefix + "_COOWNERS_EMAILS", coownerEmails.toString());
    }

    @Override
    public boolean isDisplayOwnershipSummaryBox(Run item) {
        return super.isDisplayOwnershipSummaryBox(item) && !OwnershipPlugin.getInstance().getConfiguration().getDisplayOptions().isHideRunOwnership();
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class LocatorImpl
    extends OwnershipHelperLocator<Run> {
        @Override
        public AbstractOwnershipHelper<Run> findHelper(Object item) {
            if (item instanceof Run) {
                return INSTANCE;
            }
            return null;
        }
    }
}

