/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.model.workflow;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerHelper;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.model.Node;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class OwnershipGlobalVariable
extends GlobalVariable {
    public final Object getValue(CpsScript script) throws Exception {
        Object loadedObject;
        Binding binding = script.getBinding();
        if (binding.hasVariable(this.getName())) {
            loadedObject = binding.getVariable(this.getName());
        } else {
            loadedObject = script.getClass().getClassLoader().loadClass(this.getClassName()).getConstructor(CpsScript.class).newInstance(script);
            binding.setVariable(this.getName(), loadedObject);
        }
        return loadedObject;
    }

    @Nonnull
    private String getClassName() {
        return ((Object)((Object)this)).getClass().getName() + ".Impl";
    }

    public String getName() {
        return "ownership";
    }

    @Restricted(value={NoExternalUse.class})
    public static String getSampleSnippet(String name) throws IOException {
        String resourceName = "OwnershipGlobalVariable/sample_" + name + ".groovy";
        InputStream scriptStream = OwnershipGlobalVariable.class.getResourceAsStream(resourceName);
        if (scriptStream == null) {
            throw new IOException("Cannot find sample script in " + resourceName);
        }
        return IOUtils.toString((InputStream)scriptStream, (String)"UTF-8");
    }

    @Whitelisted
    @Restricted(value={NoExternalUse.class})
    public static OwnershipDescription getJobOwnershipDescription(RunWrapper currentRun) {
        Run rawBuild = currentRun.getRawBuild();
        if (rawBuild == null) {
            throw new IllegalStateException("Cannot retrieve build from Pipeline Run Wrapper");
        }
        return JobOwnerHelper.Instance.getOwnershipDescription(rawBuild.getParent());
    }

    @CheckForNull
    @Whitelisted
    @Restricted(value={NoExternalUse.class})
    public static OwnershipDescription getNodeOwnershipDescription(@CheckForNull String nodeName) {
        Jenkins node;
        if (nodeName == null) {
            throw new IllegalStateException("Cannot get Ownership info outside the node() block");
        }
        Object object = node = "master".equals(nodeName) ? Jenkins.getActiveInstance() : Jenkins.getActiveInstance().getNode(nodeName);
        if (node == null) {
            throw new IllegalStateException("Cannot retrieve node by the name specified in env.NODE_NAME");
        }
        return NodeOwnerHelper.Instance.getOwnershipDescription((Node)node);
    }

    @Extension(optional=true)
    public static class MiscWhitelist
    extends ProxyWhitelist {
        public MiscWhitelist() throws IOException {
            super(new Whitelist[]{new StaticWhitelist(new String[]{"new java.util.TreeMap", "method groovy.lang.Closure call java.lang.Object", "method java.lang.Object toString"})});
        }
    }
}

