/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.util.mail;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.jenkinsci.plugins.ownership.util.mail.MailOptions;

public class MailFormatter {
    private static final String DEFAULT_ENCODING = "UTF-8";
    @Nonnull
    private final String encoding;
    @Nonnull
    private final String separator;

    public MailFormatter() {
        this(DEFAULT_ENCODING, MailOptions.DEFAULT.getEmailListSeparator());
    }

    public MailFormatter(@Nonnull String separator) {
        this(DEFAULT_ENCODING, separator);
    }

    public MailFormatter(@Nonnull String encoding, @Nonnull String separator) {
        this.encoding = encoding;
        this.separator = separator;
    }

    @Nonnull
    public String getEncoding() {
        return this.encoding;
    }

    @Nonnull
    public String getSeparator() {
        return this.separator;
    }

    @Nonnull
    public String createMailToString(@CheckForNull List<String> to, @CheckForNull List<String> cc, @CheckForNull List<String> bcc, @CheckForNull String subject, @CheckForNull String body) throws UnsupportedEncodingException {
        StringBuilder b = new StringBuilder("mailto:");
        String toString = this.joinMailAddresses(to);
        if (toString != null) {
            b.append(URLEncoder.encode(toString, this.encoding));
        }
        LinkedList<NameValuePair> params = new LinkedList<NameValuePair>();
        this.joinMailAddresses(cc, "cc", params);
        this.joinMailAddresses(bcc, "bcc", params);
        if (subject != null) {
            params.add((NameValuePair)new BasicNameValuePair("subject", subject));
        }
        if (body != null) {
            params.add((NameValuePair)new BasicNameValuePair("body", body));
        }
        if (!params.isEmpty()) {
            b.append("?");
            String encodedParams = URLEncodedUtils.format(params, (String)this.encoding);
            encodedParams = encodedParams.replace("+", "%20");
            b.append(encodedParams);
        }
        return b.toString();
    }

    @CheckForNull
    private String joinMailAddresses(@CheckForNull List<String> items) {
        if (items != null && items.size() > 0) {
            return StringUtils.join(items, (String)this.separator);
        }
        return null;
    }

    private void joinMailAddresses(@CheckForNull List<String> items, @CheckForNull String paramName, @Nonnull List<NameValuePair> target) throws UnsupportedEncodingException {
        String res = this.joinMailAddresses(items);
        if (res != null) {
            target.add((NameValuePair)new BasicNameValuePair(paramName, res));
        }
    }
}

