/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.util.mail;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import hudson.Util;
import hudson.model.User;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ownership.util.mail.MailFormatter;
import org.jenkinsci.plugins.ownership.util.mail.MailOptions;

public class OwnershipMailHelper {
    public static <TObjectType> String getContactOwnersMailToURL(TObjectType item, IOwnershipHelper<TObjectType> helper) {
        return OwnershipMailHelper.getMailToURL(item, helper, Mode.ContactOwners);
    }

    public static <TObjectType> String getContactAdminsMailToURL(TObjectType item, IOwnershipHelper<TObjectType> helper) {
        return OwnershipMailHelper.getMailToURL(item, helper, Mode.ContactAdmins);
    }

    private static <TObjectType> String getMailToURL(TObjectType item, IOwnershipHelper<TObjectType> helper, Mode mode) {
        String body;
        String subject;
        Set<String> coOwners;
        String email;
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return null;
        }
        OwnershipPlugin plugin = (OwnershipPlugin)instance.getPlugin(OwnershipPlugin.class);
        if (plugin == null) {
            assert (false) : "Ownership plugin has not been loaded yet";
            return null;
        }
        MailOptions mailOptions = plugin.getConfiguration().getMailOptions();
        OwnershipDescription ownershipDescription = helper.getOwnershipDescription(item);
        if (!ownershipDescription.isOwnershipEnabled()) {
            return null;
        }
        switch (mode) {
            case ContactOwners: {
                if (!mailOptions.isContactOwnersLinkDisabled()) break;
                return null;
            }
            case ContactAdmins: {
                if (!mailOptions.isContactAdminsLinkDisabled()) break;
                return null;
            }
        }
        LinkedList<String> to = new LinkedList<String>();
        LinkedList<String> cc = new LinkedList<String>();
        Map<String, String> envVars = OwnershipMailHelper.getSubstitutionVars(instance, item, helper);
        if (ownershipDescription.hasPrimaryOwner() && (email = UserStringFormatter.formatEmail(ownershipDescription.getPrimaryOwnerId())) != null) {
            switch (mode) {
                case ContactAdmins: {
                    cc.add(email);
                    break;
                }
                default: {
                    to.add(email);
                }
            }
        }
        if (!(coOwners = ownershipDescription.getSecondaryOwnerIds()).isEmpty()) {
            for (String coOwnerId : coOwners) {
                String email2 = UserStringFormatter.formatEmail(coOwnerId);
                if (email2 == null) continue;
                cc.add(email2);
            }
        }
        switch (mode) {
            case ContactOwners: {
                subject = OwnershipMailHelper.resolveVariablesFor(mailOptions.getContactOwnersSubjectTemplate(), envVars);
                body = OwnershipMailHelper.resolveVariablesFor(mailOptions.getContactOwnersBodyTemplate(), envVars);
                break;
            }
            case ContactAdmins: {
                String adminEmail = mailOptions.getAdminsContactEmail();
                to.add(adminEmail);
                subject = OwnershipMailHelper.resolveVariablesFor(mailOptions.getContactAdminsSubjectTemplate(), envVars);
                body = OwnershipMailHelper.resolveVariablesFor(mailOptions.getContactAdminsBodyTemplate(), envVars);
                break;
            }
            default: {
                assert (false) : "Unsupported mode " + (Object)((Object)mode);
                throw new IllegalStateException("Mode " + (Object)((Object)mode) + " is unsupported");
            }
        }
        MailFormatter formatter = new MailFormatter(mailOptions.getEmailListSeparator());
        try {
            String formattedURL = formatter.createMailToString(to, cc, null, subject, body);
            return formattedURL;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unsupported encoding: " + formatter.getEncoding(), ex);
        }
    }

    @Nonnull
    private static <TObjectType> Map<String, String> getSubstitutionVars(@Nonnull Jenkins jenkins, @Nonnull TObjectType item, @Nonnull IOwnershipHelper<TObjectType> helper) {
        TreeMap<String, String> res = new TreeMap<String, String>();
        User user = User.current();
        if (user != null && user != User.getUnknown()) {
            res.put("USER_ID", user.getId());
            res.put("USER_FULL_NAME", user.getFullName());
        }
        res.put("ITEM_TYPE_NAME", helper.getItemTypeName(item));
        res.put("ITEM_DISPLAY_NAME", helper.getItemDisplayName(item));
        res.put("ITEM_URL", jenkins.getRootUrl() + helper.getItemURL(item));
        return res;
    }

    @Nonnull
    private static String resolveVariablesFor(@Nonnull String inputString, @Nonnull Map<String, String> vars) {
        return Util.replaceMacro((String)inputString, vars);
    }

    private static enum Mode {
        ContactOwners,
        ContactAdmins;

    }
}

