/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.jcr.mocking.domain;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDefinitionMap
extends HashMap<String, String> {
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String KEY_VALUE_SEPARATOR = ":";
    public static final String PAIR_SEPARATOR = ",";

    public PropertyDefinitionMap(String propertyDefinition) {
        String key;
        if (propertyDefinition == null) {
            throw new RuntimeException("Property definition must not be null");
        }
        Pattern pattern = Pattern.compile("type:([a-zA-Z]+),\\s*value:(.+)");
        Matcher matcher = pattern.matcher(propertyDefinition);
        if (matcher.find()) {
            String key2 = matcher.group(1);
            this.put(TYPE, key2);
            String value = matcher.group(2);
            this.put(VALUE, value);
        } else if (propertyDefinition.contains(KEY_VALUE_SEPARATOR) && ((key = this.extractKeyFromDefinition(propertyDefinition)).equals(TYPE) || key.equals(VALUE))) {
            this.insertEntry(propertyDefinition);
        }
        if (this.size() == 0) {
            this.put(VALUE, propertyDefinition);
        }
    }

    public String getValue() {
        String value = (String)this.get(VALUE);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public int getType() {
        int intType = 1;
        String type = (String)this.get(TYPE);
        if (type != null) {
            intType = PropertyType.valueFromName((String)type);
        }
        return intType;
    }

    private void insertEntry(String propertyDefinition) {
        String key = this.extractKeyFromDefinition(propertyDefinition);
        String value = this.extractValueFromDefinition(propertyDefinition);
        this.put(key, value);
    }

    private String extractValueFromDefinition(String token) {
        return token.substring(token.indexOf(KEY_VALUE_SEPARATOR) + 1, token.length()).trim();
    }

    private String extractKeyFromDefinition(String token) {
        return token.substring(0, token.indexOf(KEY_VALUE_SEPARATOR)).trim();
    }
}

