/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.jcr.mocking.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tacitknowledge.jcr.mocking.JcrMockService;
import com.tacitknowledge.jcr.mocking.domain.PropertyDefinitionMap;
import com.tacitknowledge.jcr.testing.NodeFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class JsonMockService
implements JcrMockService {
    private final NodeFactory nodeFactory;

    public JsonMockService(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public Node fromString(Node parentNode, String jsonNodeStructure) throws RepositoryException {
        JsonObject object = this.parseJson(jsonNodeStructure);
        return this.buildChildNodes(object, parentNode);
    }

    public Node fromString(String jsonNodeStructure) throws RepositoryException {
        JsonObject jsonNodeObject = this.parseJson(jsonNodeStructure);
        return this.buildChildNodes(jsonNodeObject, null);
    }

    private Node buildChildNodes(JsonObject parentJsonObject, Node parent) throws RepositoryException {
        ArrayList<Node> childNodes = new ArrayList<Node>();
        ArrayList<Property> properties = new ArrayList<Property>();
        if (parent == null) {
            parent = this.nodeFactory.createNode("");
        }
        Set childElements = parentJsonObject.entrySet();
        for (Map.Entry childEntry : childElements) {
            String childElementName = (String)childEntry.getKey();
            JsonElement childElement = (JsonElement)childEntry.getValue();
            if (childElement.isJsonObject()) {
                Node childNode;
                JsonObject childJsonObject = childElement.getAsJsonObject();
                JsonElement nodeTypeElement = childJsonObject.get("jcr:primaryType");
                if (nodeTypeElement != null) {
                    String nodeType = nodeTypeElement.getAsString();
                    childNode = this.nodeFactory.createNode(parent, childElementName, nodeType);
                } else {
                    childNode = this.nodeFactory.createNode(parent, childElementName);
                }
                childNodes.add(childNode);
                this.buildChildNodes(childJsonObject, childNode);
                continue;
            }
            if (childElement.isJsonPrimitive()) {
                String childElementValue = childElement.getAsString();
                PropertyDefinitionMap propertyDefinitionMap = new PropertyDefinitionMap(childElementValue);
                int propertyType = propertyDefinitionMap.getType();
                String propertyValue = propertyDefinitionMap.getValue();
                Property property = this.nodeFactory.createProperty(parent, childElementName, propertyValue, propertyType);
                properties.add(property);
                continue;
            }
            if (!childElement.isJsonArray()) continue;
            String[] values = this.readMultiValuedProperty(childElement);
            Property property = this.nodeFactory.createMultiValuedProperty(parent, childElementName, values);
            properties.add(property);
        }
        this.nodeFactory.createIteratorFor(parent, childNodes);
        this.nodeFactory.createPropertyIteratorFor(parent, properties);
        return parent;
    }

    private String[] readMultiValuedProperty(JsonElement propertyElement) {
        ArrayList<String> childElementValues = new ArrayList<String>();
        JsonArray jsonArray = propertyElement.getAsJsonArray();
        for (JsonElement element : jsonArray) {
            if (!element.isJsonPrimitive()) {
                return new String[0];
            }
            childElementValues.add(element.getAsString());
        }
        return childElementValues.toArray(new String[childElementValues.size()]);
    }

    private JsonObject parseJson(String jsonString) {
        JsonParser parser = new JsonParser();
        return parser.parse(jsonString).getAsJsonObject();
    }
}

