/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.jcr.testing.impl;

import com.tacitknowledge.jcr.testing.NodeFactory;
import com.tacitknowledge.jcr.testing.impl.NodeIteratorAdapter;
import com.tacitknowledge.jcr.testing.impl.PropertyIteratorAdapter;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockNodeFactory
implements NodeFactory {
    private Session session = (Session)Mockito.mock(Session.class);

    @Override
    public Node createNode(Node parentNode, String nodeName, String nodeTypeName) throws RepositoryException {
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)nodeTypeName);
        Node childNode = this.createNode(parentNode, nodeName, nodeType);
        return childNode;
    }

    @Override
    public Property createProperty(Node parent, String name, String propertyValue, int propertyType) throws RepositoryException {
        Property property = parent.getProperty(name);
        if (property == null) {
            property = (Property)Mockito.mock(Property.class);
            Value value = this.createValueFor(property, propertyValue, propertyType);
            Mockito.when((Object)property.getValue()).thenReturn((Object)value);
            Mockito.when((Object)property.getString()).thenReturn((Object)propertyValue);
            Mockito.when((Object)property.getName()).thenReturn((Object)name);
            Mockito.when((Object)property.getType()).thenReturn((Object)propertyType);
            Mockito.when((Object)property.isMultiple()).thenReturn((Object)false);
            Mockito.when((Object)parent.getProperty(name)).thenReturn((Object)property);
        } else if (property.getValue() == null) {
            this.createValue(property, propertyValue, propertyType);
        }
        this.mockCommonMethods(property, parent, name);
        return property;
    }

    @Override
    public Node createNode(Node parent, String name, NodeType nodeType) throws RepositoryException {
        Node childNode = this.createNode(parent, name);
        if (nodeType != null) {
            Mockito.when((Object)childNode.isNodeType(nodeType.getName())).thenReturn((Object)true);
            Mockito.when((Object)childNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        }
        Mockito.when((Object)childNode.getSession()).thenReturn((Object)this.session);
        return childNode;
    }

    @Override
    public Node createNode(Node parent, String name) throws RepositoryException {
        Node childNode = null;
        if (parent != null) {
            childNode = parent.getNode(name);
        }
        if (childNode == null) {
            childNode = this.createNode(name);
            Mockito.when((Object)childNode.getParent()).thenReturn((Object)parent);
            this.buildParentHierarchy(parent, (Item)childNode, name);
        }
        String path = this.buildPathForNode(childNode);
        Mockito.when((Object)childNode.getPath()).thenReturn((Object)path);
        Mockito.when((Object)childNode.toString()).thenReturn((Object)path);
        Mockito.when((Object)childNode.getSession()).thenReturn((Object)this.session);
        return childNode;
    }

    @Override
    public Node createNode(String name) throws RepositoryException {
        Node childNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)childNode.getName()).thenReturn((Object)name);
        if ("".equals(name)) {
            Mockito.when((Object)childNode.getPath()).thenReturn((Object)"/");
            Mockito.when((Object)childNode.toString()).thenReturn((Object)"/");
            Mockito.when((Object)this.session.getRootNode()).thenReturn((Object)childNode);
        }
        Mockito.when((Object)childNode.isNode()).thenReturn((Object)true);
        return childNode;
    }

    @Override
    public Property createMultiValuedProperty(Node parent, String name, String[] propertyValues) throws RepositoryException {
        Property property = parent.getProperty(name);
        if (property == null) {
            property = (Property)Mockito.mock(Property.class);
        }
        if (property.getValue() == null) {
            Value[] values = new Value[propertyValues.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = (Value)Mockito.mock(Value.class);
                Mockito.when((Object)value.getString()).thenReturn((Object)propertyValues[i]);
                Mockito.when((Object)value.getType()).thenReturn((Object)1);
                values[i] = value;
            }
            Mockito.when((Object)property.getValues()).thenReturn((Object)values);
            Mockito.when((Object)property.getName()).thenReturn((Object)name);
            Mockito.when((Object)property.getType()).thenReturn((Object)1);
            Mockito.when((Object)property.isMultiple()).thenReturn((Object)true);
            Mockito.when((Object)parent.getProperty(name)).thenReturn((Object)property);
        }
        this.mockCommonMethods(property, parent, name);
        return property;
    }

    private void mockCommonMethods(Property property, Node parent, String name) throws RepositoryException {
        Mockito.when((Object)property.getParent()).thenReturn((Object)parent);
        Mockito.when((Object)property.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)parent.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)parent.hasProperty(name)).thenReturn((Object)true);
        Mockito.when((Object)parent.hasProperties()).thenReturn((Object)true);
        String propertyPath = parent.getPath() + "/" + name;
        Mockito.when((Object)property.getPath()).thenReturn((Object)propertyPath);
        Mockito.when((Object)property.toString()).thenReturn((Object)propertyPath);
        PropertyDefinition propertyDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)property.getDefinition()).thenReturn((Object)propertyDefinition);
        boolean isMultiple = property.isMultiple();
        Mockito.when((Object)propertyDefinition.isMultiple()).thenReturn((Object)isMultiple);
        int propertyType = property.getType();
        Mockito.when((Object)propertyDefinition.getRequiredType()).thenReturn((Object)propertyType);
        this.buildParentHierarchy(parent, (Item)property, name);
    }

    @Override
    public void createIteratorFor(Node parent, final List<Node> childNodes) throws RepositoryException {
        Mockito.when((Object)parent.getNodes()).thenAnswer((Answer)new Answer<NodeIterator>(){

            public NodeIterator answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new NodeIteratorAdapter(childNodes.iterator());
            }
        });
        Mockito.when((Object)parent.getSession()).thenReturn((Object)this.session);
    }

    @Override
    public void createPropertyIteratorFor(Node parent, final List<Property> propertyList) throws RepositoryException {
        Mockito.when((Object)parent.getProperties()).thenAnswer((Answer)new Answer<PropertyIteratorAdapter>(){

            public PropertyIteratorAdapter answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new PropertyIteratorAdapter(propertyList.iterator());
            }
        });
    }

    @Override
    public Value createValueFor(Property property, String valueStr, int valueType) throws RepositoryException {
        Value returnValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)returnValue.getType()).thenReturn((Object)valueType);
        switch (valueType) {
            case 1: {
                this.createStringValueFor(property, returnValue, valueStr);
                break;
            }
            case 2: {
                this.createBinaryValueFor(property, returnValue, valueStr);
                break;
            }
            case 6: {
                this.createBooleanValueFor(property, returnValue, valueStr);
                break;
            }
            case 4: {
                this.createDoubleValueFor(property, returnValue, valueStr);
                break;
            }
            case 12: {
                this.createDecimalValueFor(property, returnValue, valueStr);
                break;
            }
            case 3: {
                this.createLongValueFor(property, returnValue, valueStr);
                break;
            }
            case 5: {
                this.createDateValueFor(property, returnValue, valueStr);
            }
            default: {
                this.createStringValueFor(property, returnValue, valueStr);
            }
        }
        Mockito.when((Object)property.getSession()).thenReturn((Object)this.session);
        return returnValue;
    }

    private String buildPathForNode(Node node) throws RepositoryException {
        if (node != null && !"".equals(node.getName())) {
            return this.buildPathForNode(node.getParent()) + "/" + node.getName();
        }
        return "";
    }

    private void createDateValueFor(Property property, Value returnValue, String valueStr) throws RepositoryException {
        Calendar calendar;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
            Date date = simpleDateFormat.parse(valueStr);
            calendar = Calendar.getInstance();
            calendar.setTime(date);
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid format for date value: " + valueStr, e);
        }
        Mockito.when((Object)property.getDate()).thenReturn((Object)calendar);
        Mockito.when((Object)returnValue.getDate()).thenReturn((Object)calendar);
    }

    private void createLongValueFor(Property property, Value returnValue, String valueStr) throws RepositoryException {
        long longVal = Long.parseLong(valueStr);
        Mockito.when((Object)property.getLong()).thenReturn((Object)longVal);
        Mockito.when((Object)returnValue.getLong()).thenReturn((Object)longVal);
    }

    private void createDecimalValueFor(Property property, Value returnValue, String valueStr) throws RepositoryException {
        BigDecimal decimalValue = new BigDecimal(valueStr);
        Mockito.when((Object)property.getDecimal()).thenReturn((Object)decimalValue);
        Mockito.when((Object)returnValue.getDecimal()).thenReturn((Object)decimalValue);
    }

    private void createDoubleValueFor(Property property, Value returnValue, String valueStr) throws RepositoryException {
        double doubleVal = Double.parseDouble(valueStr);
        Mockito.when((Object)property.getDouble()).thenReturn((Object)doubleVal);
        Mockito.when((Object)returnValue.getDouble()).thenReturn((Object)doubleVal);
    }

    private void createStringValueFor(Property property, Value returnValue, String valueStr) throws RepositoryException {
        Mockito.when((Object)property.getString()).thenReturn((Object)valueStr);
        Mockito.when((Object)returnValue.getString()).thenReturn((Object)valueStr);
    }

    private void createBooleanValueFor(Property property, Value returnValue, String valueStr) throws RepositoryException {
        Boolean booleanVal = Boolean.valueOf(valueStr);
        Mockito.when((Object)property.getBoolean()).thenReturn((Object)booleanVal);
        Mockito.when((Object)returnValue.getBoolean()).thenReturn((Object)booleanVal);
    }

    private void createValue(Property property, String propertyValue, int propertyType) throws RepositoryException {
        Value value = this.createValueFor(property, propertyValue, propertyType);
        Mockito.when((Object)property.getValue()).thenReturn((Object)value);
    }

    private void createBinaryValueFor(Property property, Value valueObject, String propertyValue) throws RepositoryException {
        InputStream binaryInputStream = this.getClass().getResourceAsStream(propertyValue);
        if (binaryInputStream == null) {
            throw new IllegalArgumentException("Path to binary doesn't exist: " + propertyValue);
        }
        Binary binary = (Binary)Mockito.mock(Binary.class);
        Mockito.when((Object)property.getBinary()).thenReturn((Object)binary);
        Mockito.when((Object)binary.getStream()).thenReturn((Object)binaryInputStream);
        Mockito.when((Object)valueObject.getBinary()).thenReturn((Object)binary);
    }

    private void buildParentHierarchy(Node parent, Item childItem, String itemPath) throws RepositoryException {
        if (parent != null) {
            if (childItem.isNode()) {
                Mockito.when((Object)parent.getNode(itemPath)).thenReturn((Object)((Node)childItem));
                Mockito.when((Object)parent.hasNode(itemPath)).thenReturn((Object)true);
                Mockito.when((Object)parent.hasNodes()).thenReturn((Object)true);
            } else {
                Mockito.when((Object)parent.getProperty(itemPath)).thenReturn((Object)((Property)childItem));
                Mockito.when((Object)parent.hasProperty(itemPath)).thenReturn((Object)true);
                Mockito.when((Object)parent.hasProperties()).thenReturn((Object)true);
            }
            String parentName = parent.getName();
            if (parentName != null) {
                this.buildParentHierarchy(parent.getParent(), childItem, parentName + "/" + itemPath);
            }
        }
    }
}

