/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.jcr.testing.impl;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.collections.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeIteratorAdapter
implements NodeIterator {
    private int position;
    private Iterator<Node> iterator;
    private List<Node> nodeList;

    public NodeIteratorAdapter(Iterator<Node> iterator) {
        this.nodeList = IteratorUtils.toList(iterator);
        this.iterator = this.nodeList.iterator();
        this.position = 0;
    }

    public Node nextNode() {
        Node next = this.iterator.next();
        this.removeFromList(1);
        return next;
    }

    public void skip(long skipNum) {
        this.removeFromList((int)skipNum);
        this.iterator = this.nodeList.iterator();
    }

    private void removeFromList(int skipNum) {
        int size = this.nodeList.size();
        this.nodeList = this.nodeList.subList(skipNum, size);
        this.position += skipNum;
    }

    public long getSize() {
        return this.nodeList.size();
    }

    public long getPosition() {
        return this.position;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        Node next = this.iterator.next();
        this.removeFromList(1);
        return next;
    }

    public void remove() {
        this.removeFromList(1);
    }
}

