/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.jcr.testing.impl;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import org.apache.commons.collections.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyIteratorAdapter
implements PropertyIterator {
    private int position;
    private Iterator<Property> iterator;
    private List<Property> propertyList;

    public PropertyIteratorAdapter(Iterator<Property> iterator) {
        this.propertyList = IteratorUtils.toList(iterator);
        this.iterator = this.propertyList.iterator();
        this.position = 0;
    }

    public Property nextProperty() {
        Property next = this.iterator.next();
        this.removeFromList(1);
        return next;
    }

    public void skip(long skipNum) {
        this.removeFromList((int)skipNum);
        this.iterator = this.propertyList.iterator();
    }

    private void removeFromList(int skipNum) {
        int size = this.propertyList.size();
        this.propertyList = this.propertyList.subList(skipNum, size);
        this.position += skipNum;
    }

    public long getSize() {
        return this.propertyList.size();
    }

    public long getPosition() {
        return this.position;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Property next() {
        Property next = this.iterator.next();
        this.removeFromList(1);
        return next;
    }

    public void remove() {
        this.removeFromList(1);
    }
}

