/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.jcr.testing.utils;

import com.tacitknowledge.jcr.testing.utils.PropertyTypeEnum;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.junit.Assert;

public class JcrTestingUtils {
    public static void assertProperty(Property property, int expectedType, Object expectedValue) throws RepositoryException {
        JcrTestingUtils.assertPropertyType(property, expectedType);
        Assert.assertEquals((String)"Expected Empty String", (Object)expectedValue, (Object)PropertyTypeEnum.fromType(expectedType).getObjectValue(property.getValue()));
    }

    public static void assertPropertyType(Property property, int expectedType) throws RepositoryException {
        Assert.assertEquals((String)("Expected Type " + PropertyType.nameFromValue((int)expectedType) + " but got " + PropertyType.nameFromValue((int)property.getType())), (long)expectedType, (long)property.getType());
    }

    public static void assertIteratorCount(Iterator iterator, int expectedCount) {
        int counter = 0;
        while (iterator.hasNext()) {
            Assert.assertNotNull((String)"Expected a non null node", iterator.next());
            ++counter;
        }
        Assert.assertEquals((String)"Expected 1 node", (long)expectedCount, (long)counter);
    }
}

