/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.jcr.testing.utils;

import javax.jcr.RepositoryException;
import javax.jcr.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PropertyTypeEnum {
    BINARY(2){

        public Object getObjectValue(Value value) throws RepositoryException {
            return value.getBinary();
        }
    }
    ,
    BOOLEAN(6){

        public Object getObjectValue(Value value) throws RepositoryException {
            return value.getBoolean();
        }
    }
    ,
    DATE(5){

        public Object getObjectValue(Value value) throws RepositoryException {
            return value.getDate();
        }
    }
    ,
    DECIMAL(12){

        public Object getObjectValue(Value value) throws RepositoryException {
            return value.getDecimal();
        }
    }
    ,
    DOUBLE(4){

        public Object getObjectValue(Value value) throws RepositoryException {
            return value.getDouble();
        }
    }
    ,
    LONG(3){

        public Object getObjectValue(Value value) throws RepositoryException {
            return value.getLong();
        }
    }
    ,
    REFERENCE(9),
    STRING(1);

    private int propertyType;

    private PropertyTypeEnum(int propertyType) {
        this.propertyType = propertyType;
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public Object getObjectValue(Value value) throws RepositoryException {
        return value.getString();
    }

    public static PropertyTypeEnum fromType(int type) {
        PropertyTypeEnum propertyTypeEnum = null;
        for (PropertyTypeEnum enumVal : PropertyTypeEnum.values()) {
            if (type != enumVal.getPropertyType()) continue;
            propertyTypeEnum = enumVal;
        }
        if (propertyTypeEnum == null) {
            throw new RuntimeException("There's no PropertyTypeEnum for type: " + type);
        }
        return propertyTypeEnum;
    }
}

