/*
 * Decompiled with CFR 0.152.
 */
package scalapb.compiler;

import com.google.protobuf.Descriptors;
import com.google.protobuf.compiler.PluginProtos;
import java.io.Serializable;
import protocgen.CodeGenRequest;
import protocgen.CodeGenResponse;
import protocgen.CodeGenResponse$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalapb.compiler.DescriptorImplicits;
import scalapb.compiler.DescriptorImplicits$;
import scalapb.compiler.GeneratorException;
import scalapb.compiler.GeneratorParams;
import scalapb.compiler.GeneratorParams$;
import scalapb.compiler.ProtoValidation;
import scalapb.compiler.ProtobufGenerator;

public final class ProtobufGenerator$ {
    public static final ProtobufGenerator$ MODULE$ = new ProtobufGenerator$();
    private static final String deprecatedAnnotation = "@scala.deprecated(message=\"Marked as deprecated in proto file\", \"\")";

    public Either<String, GeneratorParams> parseParameters(String params) {
        return GeneratorParams$.MODULE$.fromString(params);
    }

    public CodeGenResponse handleCodeGeneratorRequest(CodeGenRequest request) {
        Either<String, GeneratorParams> either = this.parseParameters(request.parameter());
        if (either instanceof Right) {
            CodeGenResponse codeGenResponse;
            Right right = (Right)either;
            GeneratorParams params = (GeneratorParams)right.value();
            try {
                DescriptorImplicits implicits = DescriptorImplicits$.MODULE$.fromCodeGenRequest(params, request);
                ProtobufGenerator generator = new ProtobufGenerator(params, implicits);
                ProtoValidation validator = new ProtoValidation(implicits);
                validator.validateFiles((Seq<Descriptors.FileDescriptor>)request.allProtos());
                Seq files = (Seq)((IterableOps)request.filesToGenerate().filterNot((Function1 & Serializable)x$66 -> BoxesRunTime.boxToBoolean((boolean)ProtobufGenerator$.$anonfun$handleCodeGeneratorRequest$1(implicits, x$66)))).flatMap((Function1 & Serializable)file -> {
                    if (implicits.ExtendedFileDescriptor((Descriptors.FileDescriptor)file).scalaOptions().getSingleFile()) {
                        return generator.generateSingleScalaFileForFileDescriptor((Descriptors.FileDescriptor)file);
                    }
                    return generator.generateMultipleScalaFilesForFileDescriptor((Descriptors.FileDescriptor)file);
                });
                codeGenResponse = CodeGenResponse$.MODULE$.succeed(files, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PluginProtos.CodeGeneratorResponse.Feature[]{PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL, PluginProtos.CodeGeneratorResponse.Feature.FEATURE_SUPPORTS_EDITIONS})));
            }
            catch (GeneratorException e) {
                codeGenResponse = CodeGenResponse$.MODULE$.fail(e.message());
            }
            return codeGenResponse;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            return CodeGenResponse$.MODULE$.fail(error);
        }
        throw new MatchError(either);
    }

    public Seq<String> asScalaDocBlock(Seq<String> contentLines) {
        if (contentLines.nonEmpty()) {
            return (Seq)((SeqOps)((IterableOps)contentLines.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String prefix;
                    String line = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String string = prefix = index == 0 ? "/**" : "  *";
                    if (line.startsWith(" ") || line.isEmpty()) {
                        return new StringBuilder(0).append(prefix).append(line).toString();
                    }
                    return new StringBuilder(1).append(prefix).append(" ").append(line).toString();
                }
                throw new MatchError((Object)tuple2);
            })).$colon$plus((Object)"  */");
        }
        return contentLines;
    }

    public String deprecatedAnnotation() {
        return deprecatedAnnotation;
    }

    public String escapeScalaString(String raw) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(raw), (Function1 & Serializable)x0$1 -> ProtobufGenerator$.$anonfun$escapeScalaString$1(BoxesRunTime.unboxToChar((Object)x0$1))).mkString("\"", "", "\"");
    }

    public static final /* synthetic */ boolean $anonfun$handleCodeGeneratorRequest$1(DescriptorImplicits implicits$1, Descriptors.FileDescriptor x$66) {
        return implicits$1.ExtendedFileDescriptor(x$66).disableOutput();
    }

    public static final /* synthetic */ String $anonfun$escapeScalaString$1(char x0$1) {
        char c = x0$1;
        if ('\b' == c) {
            return "\\b";
        }
        if ('\f' == c) {
            return "\\f";
        }
        if ('\n' == c) {
            return "\\n";
        }
        if ('\r' == c) {
            return "\\r";
        }
        if ('\t' == c) {
            return "\\t";
        }
        if ('\\' == c) {
            return "\\\\";
        }
        if ('\"' == c) {
            return "\\\"";
        }
        if ('\'' == c) {
            return "\\'";
        }
        if (c >= ' ' && c <= '~') {
            return Character.toString(c);
        }
        if (true) {
            char c2 = c;
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%4s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper((int)c2))})).replace(' ', '0');
        }
        throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    private ProtobufGenerator$() {
    }
}

