/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertyFilter {
    public static Properties filterWithPrefix(String prefix, Properties props) {
        Properties filteredProps = new Properties();
        if (props == null || props.isEmpty()) {
            return filteredProps;
        }
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            filteredProps.put(key, props.getProperty(key));
        }
        return filteredProps;
    }

    public static Map<String, Properties> filterWithPrefixIntoMap(String prefix, Properties props) {
        Properties filteredProps = PropertyFilter.filterWithPrefix(prefix, props);
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (String propName : filteredProps.stringPropertyNames()) {
            String suffix = propName.substring(prefix.length());
            if (!suffix.contains(".")) continue;
            String mapKey = suffix.substring(0, suffix.indexOf("."));
            String keyedPropName = suffix.substring(suffix.indexOf(".") + 1);
            if (keyedPropName.isEmpty()) continue;
            Properties keyedProps = (Properties)map.get(mapKey);
            if (keyedProps == null) {
                keyedProps = new Properties();
            }
            keyedProps.setProperty(keyedPropName, props.getProperty(propName));
            map.put(mapKey, keyedProps);
        }
        return map;
    }
}

