/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerEdge;
import com.tinkerpop.blueprints.impls.tg.TinkerElement;
import com.tinkerpop.blueprints.impls.tg.TinkerIndex;
import com.tinkerpop.blueprints.impls.tg.TinkerVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.KeyIndexableGraphHelper;
import com.tinkerpop.blueprints.util.PropertyFilteredIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TinkerGraph
implements IndexableGraph,
KeyIndexableGraph,
Serializable {
    private Long currentId = 0L;
    protected Map<String, Vertex> vertices = new HashMap<String, Vertex>();
    protected Map<String, Edge> edges = new HashMap<String, Edge>();
    protected Map<String, TinkerIndex> indices = new HashMap<String, TinkerIndex>();
    protected TinkerKeyIndex<TinkerVertex> vertexKeyIndex = new TinkerKeyIndex<TinkerVertex>(TinkerVertex.class, this);
    protected TinkerKeyIndex<TinkerEdge> edgeKeyIndex = new TinkerKeyIndex<TinkerEdge>(TinkerEdge.class, this);
    private final String directory;
    private static final String GRAPH_FILE = "/tinkergraph.dat";
    private static final Features FEATURES = new Features();
    private static final Features PERSISTENT_FEATURES;

    public TinkerGraph(String directory) {
        this.directory = directory;
        try {
            File file = new File(directory);
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    throw new RuntimeException("Could not create directory");
                }
            } else {
                ObjectInputStream input = new ObjectInputStream(new FileInputStream(directory + GRAPH_FILE));
                TinkerGraph temp = (TinkerGraph)input.readObject();
                input.close();
                this.currentId = temp.currentId;
                this.vertices = temp.vertices;
                this.edges = temp.edges;
                this.indices = temp.indices;
                this.vertexKeyIndex = temp.vertexKeyIndex;
                this.edgeKeyIndex = temp.edgeKeyIndex;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public TinkerGraph() {
        this.directory = null;
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        if (this.vertexKeyIndex.getIndexedKeys().contains(key)) {
            return this.vertexKeyIndex.get(key, value);
        }
        return new PropertyFilteredIterable<Vertex>(key, value, this.getVertices());
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        if (this.edgeKeyIndex.getIndexedKeys().contains(key)) {
            return this.edgeKeyIndex.get(key, value);
        }
        return new PropertyFilteredIterable<Edge>(key, value, this.getEdges());
    }

    @Override
    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexKeyIndex.createKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            this.edgeKeyIndex.createKeyIndex(key);
        } else {
            throw ExceptionFactory.classIsNotIndexable(elementClass);
        }
    }

    @Override
    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.vertexKeyIndex.dropKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            this.edgeKeyIndex.dropKeyIndex(key);
        } else {
            throw ExceptionFactory.classIsNotIndexable(elementClass);
        }
    }

    @Override
    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return this.vertexKeyIndex.getIndexedKeys();
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return this.edgeKeyIndex.getIndexedKeys();
        }
        throw ExceptionFactory.classIsNotIndexable(elementClass);
    }

    @Override
    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        if (this.indices.containsKey(indexName)) {
            throw ExceptionFactory.indexAlreadyExists(indexName);
        }
        TinkerIndex<T> index = new TinkerIndex<T>(indexName, indexClass);
        this.indices.put(index.getIndexName(), index);
        return index;
    }

    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        Index index = this.indices.get(indexName);
        if (null == index) {
            return null;
        }
        if (!indexClass.isAssignableFrom(index.getIndexClass())) {
            throw ExceptionFactory.indexDoesNotSupportClass(indexName, indexClass);
        }
        return index;
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        ArrayList<Index<? extends Element>> list = new ArrayList<Index<? extends Element>>();
        for (TinkerIndex index : this.indices.values()) {
            list.add(index);
        }
        return list;
    }

    @Override
    public void dropIndex(String indexName) {
        this.indices.remove(indexName);
    }

    @Override
    public Vertex addVertex(Object id) {
        Vertex vertex;
        String idString = null;
        if (null != id) {
            idString = id.toString();
            vertex = this.vertices.get(idString);
            if (null != vertex) {
                throw ExceptionFactory.vertexWithIdAlreadyExists(id);
            }
        } else {
            boolean done = false;
            while (!done) {
                idString = this.getNextId();
                vertex = this.vertices.get(idString);
                if (null != vertex) continue;
                done = true;
            }
        }
        vertex = new TinkerVertex(idString, this);
        this.vertices.put(vertex.getId().toString(), vertex);
        return vertex;
    }

    @Override
    public Vertex getVertex(Object id) {
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        String idString = id.toString();
        return this.vertices.get(idString);
    }

    @Override
    public Edge getEdge(Object id) {
        if (null == id) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        String idString = id.toString();
        return this.edges.get(idString);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new ArrayList<Vertex>(this.vertices.values());
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new ArrayList<Edge>(this.edges.values());
    }

    @Override
    public void removeVertex(Vertex vertex) {
        for (Edge edge : vertex.getEdges(Direction.BOTH, new String[0])) {
            this.removeEdge(edge);
        }
        this.vertexKeyIndex.removeElement((TinkerVertex)vertex);
        for (Index index : this.getIndices()) {
            if (!Vertex.class.isAssignableFrom(index.getIndexClass())) continue;
            TinkerIndex idx = (TinkerIndex)index;
            idx.removeElement((TinkerVertex)vertex);
        }
        this.vertices.remove(vertex.getId().toString());
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Edge edge;
        String idString = null;
        if (null != id) {
            idString = id.toString();
            edge = this.edges.get(idString);
            if (null != edge) {
                throw ExceptionFactory.edgeWithIdAlreadyExist(id);
            }
        } else {
            boolean done = false;
            while (!done) {
                idString = this.getNextId();
                edge = this.edges.get(idString);
                if (null != edge) continue;
                done = true;
            }
        }
        edge = new TinkerEdge(idString, outVertex, inVertex, label, this);
        this.edges.put(edge.getId().toString(), edge);
        TinkerVertex out = (TinkerVertex)outVertex;
        TinkerVertex in = (TinkerVertex)inVertex;
        out.addOutEdge(label, edge);
        in.addInEdge(label, edge);
        return edge;
    }

    @Override
    public void removeEdge(Edge edge) {
        Set<Edge> edges;
        TinkerVertex outVertex = (TinkerVertex)edge.getVertex(Direction.OUT);
        TinkerVertex inVertex = (TinkerVertex)edge.getVertex(Direction.IN);
        if (null != outVertex && null != outVertex.outEdges && null != (edges = outVertex.outEdges.get(edge.getLabel()))) {
            edges.remove(edge);
        }
        if (null != inVertex && null != inVertex.inEdges && null != (edges = inVertex.inEdges.get(edge.getLabel()))) {
            edges.remove(edge);
        }
        this.edgeKeyIndex.removeElement((TinkerEdge)edge);
        for (Index<? extends Element> index : this.getIndices()) {
            if (!Edge.class.isAssignableFrom(index.getIndexClass())) continue;
            TinkerIndex idx = (TinkerIndex)index;
            idx.removeElement((TinkerEdge)edge);
        }
        this.edges.remove(edge.getId().toString());
    }

    public String toString() {
        if (null == this.directory) {
            return StringFactory.graphString(this, "vertices:" + this.vertices.size() + " edges:" + this.edges.size());
        }
        return StringFactory.graphString(this, "vertices:" + this.vertices.size() + " edges:" + this.edges.size() + " directory:" + this.directory);
    }

    public void clear() {
        this.vertices.clear();
        this.edges.clear();
        this.indices.clear();
        this.currentId = 0L;
        this.vertexKeyIndex = new TinkerKeyIndex<TinkerVertex>(TinkerVertex.class, this);
        this.edgeKeyIndex = new TinkerKeyIndex<TinkerEdge>(TinkerEdge.class, this);
    }

    @Override
    public void shutdown() {
        if (null != this.directory) {
            try {
                File file = new File(this.directory + GRAPH_FILE);
                if (file.exists()) {
                    file.delete();
                }
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.directory + GRAPH_FILE));
                out.writeObject(this);
                out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private String getNextId() {
        String idString;
        do {
            idString = this.currentId.toString();
            TinkerGraph tinkerGraph = this;
            Long l = tinkerGraph.currentId;
            Long l2 = tinkerGraph.currentId = Long.valueOf(tinkerGraph.currentId + 1L);
        } while (null != this.vertices.get(idString) && null != this.edges.get(idString) && this.currentId != Long.MAX_VALUE);
        return idString;
    }

    @Override
    public Features getFeatures() {
        if (null == this.directory) {
            return FEATURES;
        }
        return PERSISTENT_FEATURES;
    }

    static {
        TinkerGraph.FEATURES.supportsDuplicateEdges = true;
        TinkerGraph.FEATURES.supportsSelfLoops = true;
        TinkerGraph.FEATURES.supportsSerializableObjectProperty = true;
        TinkerGraph.FEATURES.supportsBooleanProperty = true;
        TinkerGraph.FEATURES.supportsDoubleProperty = true;
        TinkerGraph.FEATURES.supportsFloatProperty = true;
        TinkerGraph.FEATURES.supportsIntegerProperty = true;
        TinkerGraph.FEATURES.supportsPrimitiveArrayProperty = true;
        TinkerGraph.FEATURES.supportsUniformListProperty = true;
        TinkerGraph.FEATURES.supportsMixedListProperty = true;
        TinkerGraph.FEATURES.supportsLongProperty = true;
        TinkerGraph.FEATURES.supportsMapProperty = true;
        TinkerGraph.FEATURES.supportsStringProperty = true;
        TinkerGraph.FEATURES.ignoresSuppliedIds = false;
        TinkerGraph.FEATURES.isPersistent = false;
        TinkerGraph.FEATURES.isRDFModel = false;
        TinkerGraph.FEATURES.isWrapper = false;
        TinkerGraph.FEATURES.supportsIndices = true;
        TinkerGraph.FEATURES.supportsKeyIndices = true;
        TinkerGraph.FEATURES.supportsVertexKeyIndex = true;
        TinkerGraph.FEATURES.supportsEdgeKeyIndex = true;
        TinkerGraph.FEATURES.supportsVertexIndex = true;
        TinkerGraph.FEATURES.supportsEdgeIndex = true;
        TinkerGraph.FEATURES.supportsTransactions = false;
        TinkerGraph.FEATURES.supportsVertexIteration = true;
        TinkerGraph.FEATURES.supportsEdgeIteration = true;
        TinkerGraph.FEATURES.supportsEdgeRetrieval = true;
        TinkerGraph.FEATURES.supportsVertexProperties = true;
        TinkerGraph.FEATURES.supportsEdgeProperties = true;
        TinkerGraph.FEATURES.supportsThreadedTransactions = false;
        PERSISTENT_FEATURES = FEATURES.copyFeatures();
        TinkerGraph.PERSISTENT_FEATURES.isPersistent = true;
    }

    protected class TinkerKeyIndex<T extends TinkerElement>
    extends TinkerIndex<T>
    implements Serializable {
        private final Set<String> indexedKeys;
        private TinkerGraph graph;

        public TinkerKeyIndex(Class<T> indexClass, TinkerGraph graph) {
            super(null, indexClass);
            this.indexedKeys = new HashSet<String>();
            this.graph = graph;
        }

        public void autoUpdate(String key, Object newValue, Object oldValue, T element) {
            if (this.indexedKeys.contains(key)) {
                if (oldValue != null) {
                    this.remove(key, oldValue, element);
                }
                this.put(key, newValue, element);
            }
        }

        public void autoRemove(String key, Object oldValue, T element) {
            if (this.indexedKeys.contains(key)) {
                this.remove(key, oldValue, element);
            }
        }

        public void createKeyIndex(String key) {
            if (this.indexedKeys.contains(key)) {
                return;
            }
            this.indexedKeys.add(key);
            if (TinkerVertex.class.equals((Object)this.indexClass)) {
                KeyIndexableGraphHelper.reIndexElements(this.graph, this.graph.getVertices(), new HashSet<String>(Arrays.asList(key)));
            } else {
                KeyIndexableGraphHelper.reIndexElements(this.graph, this.graph.getEdges(), new HashSet<String>(Arrays.asList(key)));
            }
        }

        public void dropKeyIndex(String key) {
            if (!this.indexedKeys.contains(key)) {
                return;
            }
            this.indexedKeys.remove(key);
            this.index.remove(key);
        }

        public Set<String> getIndexedKeys() {
            if (null != this.indexedKeys) {
                return new HashSet<String>(this.indexedKeys);
            }
            return Collections.emptySet();
        }
    }
}

