/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch.cache;

import cern.colt.function.LongObjectProcedure;
import cern.colt.map.AbstractLongObjectMap;
import cern.colt.map.OpenLongObjectHashMap;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;

public class LongIDVertexCache
implements VertexCache {
    private static final int INITIAL_CAPACITY = 1000;
    private final Graph graph;
    private final AbstractLongObjectMap map;

    public LongIDVertexCache(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph expected.");
        }
        this.graph = graph;
        this.map = new OpenLongObjectHashMap(1000);
    }

    private static final long getID(Object externalID) {
        if (!(externalID instanceof Number)) {
            throw new IllegalArgumentException("Number expected.");
        }
        return ((Number)externalID).longValue();
    }

    @Override
    public Object getEntry(Object externalID) {
        long id = LongIDVertexCache.getID(externalID);
        return this.map.get(id);
    }

    @Override
    public void set(Vertex vertex, Object externalID) {
        long id = LongIDVertexCache.getID(externalID);
        this.map.put(id, (Object)vertex);
    }

    @Override
    public void newTransaction() {
        this.map.forEachPair(new LongObjectProcedure(){

            public boolean apply(long l, Object o) {
                if (o instanceof Vertex) {
                    LongIDVertexCache.this.map.put(l, ((Vertex)o).getId());
                }
                return true;
            }
        });
    }
}

