/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch.cache;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.StringCompression;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;
import java.util.HashMap;
import java.util.Map;

public class StringIDVertexCache
implements VertexCache {
    private static final int INITIAL_CAPACITY = 1000;
    private final Graph graph;
    private final Map<String, Object> map;
    private final StringCompression compression;

    public StringIDVertexCache(Graph graph, StringCompression compression) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph expected.");
        }
        if (compression == null) {
            throw new IllegalArgumentException("Compression expected.");
        }
        this.graph = graph;
        this.compression = compression;
        this.map = new HashMap<String, Object>(1000);
    }

    public StringIDVertexCache(Graph graph) {
        this(graph, StringCompression.NO_COMPRESSION);
    }

    @Override
    public Object getEntry(Object externalID) {
        String id = this.compression.compress((String)externalID);
        return this.map.get(id);
    }

    @Override
    public void set(Vertex vertex, Object externalID) {
        String id = this.compression.compress((String)externalID);
        this.map.put(id, vertex);
    }

    @Override
    public void newTransaction() {
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (!(entry.getValue() instanceof Vertex)) continue;
            Vertex v = (Vertex)entry.getValue();
            entry.setValue(v.getId());
        }
    }
}

