/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.partition;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionGraph;
import java.util.HashSet;
import java.util.Set;

public abstract class PartitionElement
implements Element {
    protected Element baseElement;
    protected PartitionGraph graph;

    protected PartitionElement(Element baseElement, PartitionGraph graph) {
        this.baseElement = baseElement;
        this.graph = graph;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (!key.equals(this.graph.getPartitionKey())) {
            this.baseElement.setProperty(key, value);
        }
    }

    @Override
    public Object getProperty(String key) {
        if (key.equals(this.graph.getPartitionKey())) {
            return null;
        }
        return this.baseElement.getProperty(key);
    }

    @Override
    public Object removeProperty(String key) {
        if (key.equals(this.graph.getPartitionKey())) {
            return null;
        }
        return this.baseElement.removeProperty(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        HashSet<String> keys = new HashSet<String>(this.baseElement.getPropertyKeys());
        keys.remove(this.graph.getPartitionKey());
        return keys;
    }

    @Override
    public Object getId() {
        return this.baseElement.getId();
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    public int hashCode() {
        return this.baseElement.hashCode();
    }

    public Element getBaseElement() {
        return this.baseElement;
    }

    public String getPartition() {
        return (String)this.baseElement.getProperty(this.graph.getPartitionKey());
    }

    public void setPartition(String partition) {
        this.baseElement.setProperty(this.graph.getPartitionKey(), partition);
    }

    public String toString() {
        return this.baseElement.toString();
    }
}

