/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.wrapped;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.wrapped.WrappedEdge;
import com.tinkerpop.blueprints.util.wrappers.wrapped.WrappedEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.wrapped.WrappedVertex;
import com.tinkerpop.blueprints.util.wrappers.wrapped.WrappedVertexIterable;

public class WrappedGraph<T extends Graph>
implements Graph,
WrapperGraph<T> {
    protected T baseGraph;
    private final Features features;

    public WrappedGraph(T baseGraph) {
        this.baseGraph = baseGraph;
        this.features = this.baseGraph.getFeatures().copyFeatures();
        this.features.isWrapper = true;
    }

    @Override
    public void shutdown() {
        this.baseGraph.shutdown();
    }

    @Override
    public Vertex addVertex(Object id) {
        return new WrappedVertex(this.baseGraph.addVertex(id));
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.baseGraph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        return new WrappedVertex(vertex);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new WrappedVertexIterable(this.baseGraph.getVertices());
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        return new WrappedVertexIterable(this.baseGraph.getVertices(key, value));
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return new WrappedEdge(this.baseGraph.addEdge(id, ((WrappedVertex)outVertex).getBaseVertex(), ((WrappedVertex)inVertex).getBaseVertex(), label));
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.baseGraph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new WrappedEdge(edge);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new WrappedEdgeIterable(this.baseGraph.getEdges());
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        return new WrappedEdgeIterable(this.baseGraph.getEdges(key, value));
    }

    @Override
    public void removeEdge(Edge edge) {
        this.baseGraph.removeEdge(((WrappedEdge)edge).getBaseEdge());
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.baseGraph.removeVertex(((WrappedVertex)vertex).getBaseVertex());
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }
}

