/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.DefaultQuery;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultGraphQuery
extends DefaultQuery
implements GraphQuery {
    protected final Graph graph;

    public DefaultGraphQuery(Graph graph) {
        this.graph = graph;
    }

    @Override
    public GraphQuery has(String key) {
        super.has(key);
        return this;
    }

    @Override
    public GraphQuery hasNot(String key) {
        super.hasNot(key);
        return this;
    }

    @Override
    public GraphQuery has(String key, Object value) {
        super.has(key, value);
        return this;
    }

    @Override
    public GraphQuery hasNot(String key, Object value) {
        super.hasNot(key, value);
        return this;
    }

    @Override
    public GraphQuery has(String key, Predicate predicate, Object value) {
        super.has(key, predicate, value);
        return this;
    }

    @Override
    public <T extends Comparable<T>> GraphQuery has(String key, T value, Query.Compare compare) {
        super.has(key, compare, value);
        return this;
    }

    @Override
    public <T extends Comparable<?>> GraphQuery interval(String key, T startValue, T endValue) {
        super.interval(key, startValue, endValue);
        return this;
    }

    @Override
    public GraphQuery limit(int limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public Iterable<Edge> edges() {
        return new DefaultGraphQueryIterable<Edge>(false);
    }

    @Override
    public Iterable<Vertex> vertices() {
        return new DefaultGraphQueryIterable<Vertex>(true);
    }

    private class DefaultGraphQueryIterable<T extends Element>
    implements Iterable<T> {
        private Iterable<T> iterable = null;

        public DefaultGraphQueryIterable(boolean forVertex) {
            this.iterable = this.getElementIterable(forVertex ? Vertex.class : Edge.class);
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                T nextElement = null;
                final Iterator<T> itty = DefaultGraphQueryIterable.access$000(DefaultGraphQueryIterable.this).iterator();
                long count = 0L;

                @Override
                public boolean hasNext() {
                    if (null != this.nextElement) {
                        return true;
                    }
                    return this.loadNext();
                }

                @Override
                public T next() {
                    do {
                        if (this.nextElement == null) continue;
                        Object temp = this.nextElement;
                        this.nextElement = null;
                        return temp;
                    } while (this.loadNext());
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private boolean loadNext() {
                    this.nextElement = null;
                    if (this.count > (long)DefaultGraphQuery.this.limit) {
                        return false;
                    }
                    while (this.itty.hasNext()) {
                        Element element = (Element)this.itty.next();
                        boolean filter = false;
                        for (DefaultQuery.HasContainer hasContainer : DefaultGraphQuery.this.hasContainers) {
                            if (hasContainer.isLegal(element)) continue;
                            filter = true;
                            break;
                        }
                        if (filter || ++this.count > (long)DefaultGraphQuery.this.limit) continue;
                        this.nextElement = element;
                        return true;
                    }
                    return false;
                }
            };
        }

        private Iterable<?> getElementIterable(Class<? extends Element> elementClass) {
            if (DefaultGraphQuery.this.graph instanceof KeyIndexableGraph) {
                Set<String> keys = ((KeyIndexableGraph)DefaultGraphQuery.this.graph).getIndexedKeys(elementClass);
                DefaultQuery.HasContainer container = null;
                for (DefaultQuery.HasContainer hasContainer : DefaultGraphQuery.this.hasContainers) {
                    if (!hasContainer.predicate.equals(Compare.EQUAL) || !keys.contains(hasContainer.key)) continue;
                    container = hasContainer;
                    break;
                }
                if (container != null) {
                    if (Vertex.class.isAssignableFrom(elementClass)) {
                        return DefaultGraphQuery.this.graph.getVertices(container.key, container.value);
                    }
                    return DefaultGraphQuery.this.graph.getEdges(container.key, container.value);
                }
            }
            if (Vertex.class.isAssignableFrom(elementClass)) {
                return DefaultGraphQuery.this.graph.getVertices();
            }
            return DefaultGraphQuery.this.graph.getEdges();
        }

        static /* synthetic */ Iterable access$000(DefaultGraphQueryIterable x0) {
            return x0.iterable;
        }
    }
}

