/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.event.EventEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.event.EventElement;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventVertexIterable;

public class EventIndex<T extends Element>
implements Index<T> {
    protected final Index<T> rawIndex;
    private final EventGraph eventGraph;

    public EventIndex(Index<T> rawIndex, EventGraph eventGraph) {
        this.rawIndex = rawIndex;
        this.eventGraph = eventGraph;
    }

    @Override
    public void remove(String key, Object value, T element) {
        this.rawIndex.remove(key, value, ((EventElement)element).getBaseElement());
    }

    @Override
    public void put(String key, Object value, T element) {
        this.rawIndex.put(key, value, ((EventElement)element).getBaseElement());
    }

    @Override
    public CloseableIterable<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new EventVertexIterable(this.rawIndex.get(key, value), this.eventGraph);
        }
        return new EventEdgeIterable(this.rawIndex.get(key, value), this.eventGraph);
    }

    @Override
    public CloseableIterable<T> query(String key, Object query) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new EventVertexIterable(this.rawIndex.query(key, query), this.eventGraph);
        }
        return new EventEdgeIterable(this.rawIndex.query(key, query), this.eventGraph);
    }

    @Override
    public long count(String key, Object value) {
        return this.rawIndex.count(key, value);
    }

    @Override
    public String getIndexName() {
        return this.rawIndex.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.rawIndex.getIndexClass();
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

