/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.id;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrappedGraphQuery;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdge;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdgeIndex;
import com.tinkerpop.blueprints.util.wrappers.id.IdEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.id.IdElement;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertex;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertexIndex;
import com.tinkerpop.blueprints.util.wrappers.id.IdVertexIterable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;

public class IdGraph<T extends KeyIndexableGraph>
implements KeyIndexableGraph,
WrapperGraph<T>,
IndexableGraph,
TransactionalGraph {
    public static final String ID = "__id";
    private final T baseGraph;
    private IdFactory vertexIdFactory;
    private IdFactory edgeIdFactory;
    private final Features features;
    private final boolean supportVertexIds;
    private final boolean supportEdgeIds;
    private boolean uniqueIds = true;

    public IdGraph(T baseGraph) {
        this(baseGraph, true, true);
    }

    public IdGraph(T baseGraph, boolean supportVertexIds, boolean supportEdgeIds) {
        this.baseGraph = baseGraph;
        this.features = this.baseGraph.getFeatures().copyFeatures();
        this.features.isWrapper = true;
        this.features.ignoresSuppliedIds = false;
        this.supportVertexIds = supportVertexIds;
        this.supportEdgeIds = supportEdgeIds;
        if (!supportVertexIds && !supportEdgeIds) {
            throw new IllegalArgumentException("if neither custom vertex IDs nor custom edge IDs are supported, IdGraph can't help you!");
        }
        this.createIndices();
        this.vertexIdFactory = new DefaultIdFactory();
        this.edgeIdFactory = new DefaultIdFactory();
    }

    public void setVertexIdFactory(IdFactory idFactory) {
        this.vertexIdFactory = idFactory;
    }

    public void setEdgeIdFactory(IdFactory idFactory) {
        this.edgeIdFactory = idFactory;
    }

    public IdFactory getVertexIdFactory() {
        return this.vertexIdFactory;
    }

    public IdFactory getEdgeIdFactory() {
        return this.edgeIdFactory;
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public Vertex addVertex(Object id) {
        if (this.uniqueIds && null != id && null != this.getVertex(id)) {
            throw new IllegalArgumentException("vertex with given id already exists: '" + id + "'");
        }
        Vertex base = this.baseGraph.addVertex(null);
        if (this.supportVertexIds) {
            Object v;
            Object object = v = null == id ? this.vertexIdFactory.createId() : id;
            if (null != v) {
                base.setProperty(ID, v);
            }
        }
        return new IdVertex(base, this);
    }

    @Override
    public Vertex getVertex(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("vertex identifier cannot be null");
        }
        if (this.supportVertexIds) {
            Iterable<Vertex> i = this.baseGraph.getVertices(ID, id);
            Iterator<Vertex> iter = i.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            Vertex e = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("multiple vertices exist with id '" + id + "'");
            }
            return new IdVertex(e, this);
        }
        Vertex base = this.baseGraph.getVertex(id);
        return null == base ? null : new IdVertex(base, this);
    }

    @Override
    public void removeVertex(Vertex vertex) {
        IdGraph.verifyNativeElement(vertex);
        this.baseGraph.removeVertex(((IdVertex)vertex).getBaseVertex());
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new IdVertexIterable(this.baseGraph.getVertices(), this);
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        if (this.supportVertexIds && key.equals(ID)) {
            throw new IllegalArgumentException("index key __id is reserved by IdGraph");
        }
        return new IdVertexIterable(this.baseGraph.getVertices(key, value), this);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        if (this.uniqueIds && null != id && null != this.getEdge(id)) {
            throw new IllegalArgumentException("edge with given id already exists: " + id);
        }
        IdGraph.verifyNativeElement(outVertex);
        IdGraph.verifyNativeElement(inVertex);
        Edge base = this.baseGraph.addEdge(null, ((IdVertex)outVertex).getBaseVertex(), ((IdVertex)inVertex).getBaseVertex(), label);
        if (this.supportEdgeIds) {
            Object v;
            Object object = v = null == id ? this.edgeIdFactory.createId() : id;
            if (null != v) {
                base.setProperty(ID, v);
            }
        }
        return new IdEdge(base, this);
    }

    @Override
    public Edge getEdge(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("edge identifier cannot be null");
        }
        if (this.supportEdgeIds) {
            Iterable<Edge> i = this.baseGraph.getEdges(ID, id);
            Iterator<Edge> iter = i.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            Edge e = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("multiple edges exist with id " + id);
            }
            return new IdEdge(e, this);
        }
        Edge base = this.baseGraph.getEdge(id);
        return null == base ? null : new IdEdge(base, this);
    }

    @Override
    public void removeEdge(Edge edge) {
        IdGraph.verifyNativeElement(edge);
        this.baseGraph.removeEdge(((IdEdge)edge).getBaseEdge());
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new IdEdgeIterable(this.baseGraph.getEdges(), this);
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        if (this.supportEdgeIds && key.equals(ID)) {
            throw new IllegalArgumentException("index key __id is reserved by IdGraph");
        }
        return new IdEdgeIterable(this.baseGraph.getEdges(key, value), this);
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void rollback() {
        if (this.baseGraph instanceof TransactionalGraph) {
            ((TransactionalGraph)this.baseGraph).rollback();
        }
    }

    @Override
    public void commit() {
        if (this.baseGraph instanceof TransactionalGraph) {
            ((TransactionalGraph)this.baseGraph).commit();
        }
    }

    @Override
    public void shutdown() {
        this.baseGraph.shutdown();
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        boolean supported;
        boolean v = this.isVertexClass(elementClass);
        boolean bl = supported = v && this.supportVertexIds || !v && this.supportEdgeIds;
        if (supported && key.equals(ID)) {
            throw new IllegalArgumentException("index key __id is reserved by IdGraph");
        }
        this.baseGraph.dropKeyIndex(key, elementClass);
    }

    @Override
    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        boolean supported;
        boolean v = this.isVertexClass(elementClass);
        boolean bl = supported = v && this.supportVertexIds || !v && this.supportEdgeIds;
        if (supported && key.equals(ID)) {
            throw new IllegalArgumentException("index key __id is reserved by IdGraph");
        }
        this.baseGraph.createKeyIndex(key, elementClass, indexParameters);
    }

    @Override
    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        boolean supported;
        boolean v = this.isVertexClass(elementClass);
        boolean bl = supported = v && this.supportVertexIds || !v && this.supportEdgeIds;
        if (supported) {
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(this.baseGraph.getIndexedKeys(elementClass));
            keys.remove(ID);
            return keys;
        }
        return this.baseGraph.getIndexedKeys(elementClass);
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    public void enforceUniqueIds(boolean enforceUniqueIds) {
        this.uniqueIds = enforceUniqueIds;
    }

    @Override
    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        this.verifyBaseGraphIsIndexableGraph();
        return this.isVertexClass(indexClass) ? new IdVertexIndex(((IndexableGraph)this.baseGraph).createIndex(indexName, indexClass, indexParameters), this) : new IdEdgeIndex(((IndexableGraph)this.baseGraph).createIndex(indexName, indexClass, indexParameters), this);
    }

    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        this.verifyBaseGraphIsIndexableGraph();
        if (this.isVertexClass(indexClass)) {
            Index<Vertex> baseIndex = ((IndexableGraph)this.baseGraph).getIndex(indexName, indexClass);
            return null == baseIndex ? null : new IdVertexIndex(baseIndex, this);
        }
        Index<Edge> baseIndex = ((IndexableGraph)this.baseGraph).getIndex(indexName, indexClass);
        return null == baseIndex ? null : new IdEdgeIndex(baseIndex, this);
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        throw new UnsupportedOperationException("sorry, you currently can't get a list of indexes through IdGraph");
    }

    @Override
    public void dropIndex(String indexName) {
        this.verifyBaseGraphIsIndexableGraph();
        ((IndexableGraph)this.baseGraph).dropIndex(indexName);
    }

    @Override
    public GraphQuery query() {
        final IdGraph idGraph = this;
        return new WrappedGraphQuery(this.baseGraph.query()){

            @Override
            public Iterable<Edge> edges() {
                return new IdEdgeIterable(this.query.edges(), idGraph);
            }

            @Override
            public Iterable<Vertex> vertices() {
                return new IdVertexIterable(this.query.vertices(), idGraph);
            }
        };
    }

    public boolean getSupportVertexIds() {
        return this.supportVertexIds;
    }

    public boolean getSupportEdgeIds() {
        return this.supportEdgeIds;
    }

    private void verifyBaseGraphIsIndexableGraph() {
        if (!(this.baseGraph instanceof IndexableGraph)) {
            throw new IllegalStateException("base graph is not an indexable graph");
        }
    }

    private boolean isVertexClass(Class c) {
        return Vertex.class.isAssignableFrom(c);
    }

    private void createIndices() {
        if (this.supportVertexIds && !this.baseGraph.getIndexedKeys(Vertex.class).contains(ID)) {
            this.baseGraph.createKeyIndex(ID, Vertex.class, new Parameter[0]);
        }
        if (this.supportEdgeIds && !this.baseGraph.getIndexedKeys(Edge.class).contains(ID)) {
            this.baseGraph.createKeyIndex(ID, Edge.class, new Parameter[0]);
        }
    }

    private static void verifyNativeElement(Element e) {
        if (!(e instanceof IdElement)) {
            throw new IllegalArgumentException("given element was not created in this graph");
        }
    }

    private static class DefaultIdFactory
    implements IdFactory {
        private DefaultIdFactory() {
        }

        @Override
        public Object createId() {
            return UUID.randomUUID().toString();
        }
    }

    public static interface IdFactory {
        public Object createId();
    }
}

