/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.partition;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrappedGraphQuery;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionEdge;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionElement;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertex;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertexIterable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PartitionGraph<T extends Graph>
implements Graph,
WrapperGraph<T> {
    protected T baseGraph;
    private String writePartition;
    private Set<String> readPartitions = new HashSet<String>();
    private String partitionKey;
    private final Features features;

    public PartitionGraph(T baseGraph, String partitionKey, String writePartition, Set<String> readPartitions) {
        this.baseGraph = baseGraph;
        this.partitionKey = partitionKey;
        this.writePartition = writePartition;
        this.readPartitions.addAll(readPartitions);
        this.features = this.baseGraph.getFeatures().copyFeatures();
        this.features.isWrapper = true;
    }

    public PartitionGraph(T baseGraph, String partitionKey, String readWritePartition) {
        this(baseGraph, partitionKey, readWritePartition, new HashSet<String>(Arrays.asList(readWritePartition)));
    }

    public String getWritePartition() {
        return this.writePartition;
    }

    public void setWritePartition(String writePartition) {
        this.writePartition = writePartition;
    }

    public Set<String> getReadPartitions() {
        return new HashSet<String>(this.readPartitions);
    }

    public void removeReadPartition(String readPartition) {
        this.readPartitions.remove(readPartition);
    }

    public void addReadPartition(String readPartition) {
        this.readPartitions.add(readPartition);
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public boolean isInPartition(Element element) {
        String writePartition = element instanceof PartitionElement ? ((PartitionElement)element).getPartition() : (String)element.getProperty(this.partitionKey);
        return null == writePartition || this.readPartitions.contains(writePartition);
    }

    @Override
    public void shutdown() {
        this.baseGraph.shutdown();
    }

    @Override
    public Vertex addVertex(Object id) {
        PartitionVertex vertex = new PartitionVertex(this.baseGraph.addVertex(id), this);
        vertex.setPartition(this.writePartition);
        return vertex;
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.baseGraph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        if (this.isInPartition(vertex)) {
            return new PartitionVertex(vertex, this);
        }
        return null;
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new PartitionVertexIterable(this.baseGraph.getVertices(), this);
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        return new PartitionVertexIterable(this.baseGraph.getVertices(key, value), this);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        PartitionEdge edge = new PartitionEdge(this.baseGraph.addEdge(id, ((PartitionVertex)outVertex).getBaseVertex(), ((PartitionVertex)inVertex).getBaseVertex(), label), this);
        edge.setPartition(this.writePartition);
        return edge;
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.baseGraph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new PartitionEdge(edge, this);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new PartitionEdgeIterable(this.baseGraph.getEdges(), this);
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        return new PartitionEdgeIterable(this.baseGraph.getEdges(key, value), this);
    }

    @Override
    public void removeEdge(Edge edge) {
        this.baseGraph.removeEdge(((PartitionEdge)edge).getBaseEdge());
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.baseGraph.removeVertex(((PartitionVertex)vertex).getBaseVertex());
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public GraphQuery query() {
        final PartitionGraph partitionGraph = this;
        return new WrappedGraphQuery(this.baseGraph.query()){

            @Override
            public Iterable<Edge> edges() {
                return new PartitionEdgeIterable(this.query.edges(), partitionGraph);
            }

            @Override
            public Iterable<Vertex> vertices() {
                return new PartitionVertexIterable(this.query.vertices(), partitionGraph);
            }
        };
    }
}

