/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.core.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.junit.ArchTestInitializationException;
import com.tngtech.archunit.junit.ArchUnitEngineDescriptor;
import com.tngtech.archunit.junit.ArchUnitEngineExecutionContext;
import com.tngtech.archunit.junit.ArchUnitTestDescriptor;
import com.tngtech.archunit.junit.ClassCache;
import com.tngtech.archunit.junit.ElementResolver;
import com.tngtech.archunit.junit.FieldSelector;
import com.tngtech.archunit.junit.ReflectionUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;

@Internal
public final class ArchUnitTestEngine
extends HierarchicalTestEngine<ArchUnitEngineExecutionContext> {
    static final String UNIQUE_ID = "archunit";
    private SharedCache cache = new SharedCache();

    public String getId() {
        return UNIQUE_ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        ArchUnitEngineDescriptor result = new ArchUnitEngineDescriptor(uniqueId);
        this.resolveRequestedClasspathRoot(discoveryRequest, uniqueId, result);
        this.resolveRequestedPackages(discoveryRequest, uniqueId, result);
        this.resolveRequestedClasses(discoveryRequest, uniqueId, result);
        this.resolveRequestedMethods(discoveryRequest, uniqueId, result);
        this.resolveRequestedFields(discoveryRequest, uniqueId, result);
        this.resolveRequestedUniqueIds(discoveryRequest, uniqueId, result);
        return result;
    }

    private void resolveRequestedClasspathRoot(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId, ArchUnitEngineDescriptor result) {
        Stream<JavaClass> classes = discoveryRequest.getSelectorsByType(ClasspathRootSelector.class).stream().flatMap(this::getContainedClasses);
        this.filterCandidatesAndLoadClasses(classes, discoveryRequest).forEach(clazz -> ArchUnitTestDescriptor.resolve((TestDescriptor)result, ElementResolver.create(result, uniqueId, clazz), this.cache.get()));
    }

    private void resolveRequestedPackages(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId, ArchUnitEngineDescriptor result) {
        String[] packages = (String[])discoveryRequest.getSelectorsByType(PackageSelector.class).stream().map(PackageSelector::getPackageName).toArray(String[]::new);
        Stream<JavaClass> classes = this.getContainedClasses(packages);
        this.filterCandidatesAndLoadClasses(classes, discoveryRequest).forEach(clazz -> ArchUnitTestDescriptor.resolve((TestDescriptor)result, ElementResolver.create(result, uniqueId, clazz), this.cache.get()));
    }

    private Stream<Class<?>> filterCandidatesAndLoadClasses(Stream<JavaClass> classes, EngineDiscoveryRequest discoveryRequest) {
        return classes.filter(this.isAllowedBy(discoveryRequest)).filter(this::isArchUnitTestCandidate).flatMap(this::safelyReflect);
    }

    private void resolveRequestedClasses(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId, ArchUnitEngineDescriptor result) {
        discoveryRequest.getSelectorsByType(ClassSelector.class).stream().map(ClassSelector::getJavaClass).filter(this::isArchUnitTestCandidate).forEach(clazz -> ArchUnitTestDescriptor.resolve((TestDescriptor)result, ElementResolver.create(result, uniqueId, clazz), this.cache.get()));
    }

    private void resolveRequestedMethods(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId, ArchUnitEngineDescriptor result) {
        discoveryRequest.getSelectorsByType(MethodSelector.class).stream().filter(s -> s.getJavaMethod().isAnnotationPresent(ArchTest.class)).forEach(selector -> ArchUnitTestDescriptor.resolve((TestDescriptor)result, ElementResolver.create(result, uniqueId, selector.getJavaClass(), selector.getJavaMethod()), this.cache.get()));
    }

    private void resolveRequestedFields(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId, ArchUnitEngineDescriptor result) {
        discoveryRequest.getSelectorsByType(FieldSelector.class).stream().filter(s -> s.getJavaField().isAnnotationPresent(ArchTest.class)).forEach(selector -> ArchUnitTestDescriptor.resolve((TestDescriptor)result, ElementResolver.create(result, uniqueId, selector.getJavaClass(), selector.getJavaField()), this.cache.get()));
    }

    private void resolveRequestedUniqueIds(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId, ArchUnitEngineDescriptor result) {
        discoveryRequest.getSelectorsByType(UniqueIdSelector.class).stream().filter(selector -> selector.getUniqueId().getEngineId().equals(Optional.of(this.getId()))).forEach(selector -> ArchUnitTestDescriptor.resolve((TestDescriptor)result, ElementResolver.create(result, uniqueId, selector.getUniqueId()), this.cache.get()));
    }

    private Stream<JavaClass> getContainedClasses(String[] packages) {
        return new ClassFileImporter().importPackages(packages).stream();
    }

    private Stream<JavaClass> getContainedClasses(ClasspathRootSelector selector) {
        return new ClassFileImporter().importUrl(this.toUrl(selector.getClasspathRoot())).stream();
    }

    private Predicate<JavaClass> isAllowedBy(EngineDiscoveryRequest discoveryRequest) {
        List filters = Stream.concat(discoveryRequest.getFiltersByType(ClassNameFilter.class).stream(), discoveryRequest.getFiltersByType(PackageNameFilter.class).stream()).map(Filter::toPredicate).collect(Collectors.toList());
        return javaClass -> filters.stream().allMatch(p -> p.test(javaClass.getName()));
    }

    private boolean isArchUnitTestCandidate(JavaClass javaClass) {
        return javaClass.getAllMembers().stream().anyMatch(m -> m.isAnnotatedWith(ArchTest.class));
    }

    @MayResolveTypesViaReflection(reason="Within the ArchUnitTestEngine we may resolve types via reflection, since they are needed anyway")
    private Stream<Class<?>> safelyReflect(JavaClass javaClass) {
        try {
            return Stream.of(javaClass.reflect());
        }
        catch (NoClassDefFoundError | RuntimeException e) {
            return Stream.empty();
        }
    }

    private boolean isArchUnitTestCandidate(Class<?> clazz) {
        try {
            return !ReflectionUtils.getAllFields(clazz, ReflectionUtils.withAnnotation(ArchTest.class)).isEmpty() || !ReflectionUtils.getAllMethods(clazz, ReflectionUtils.withAnnotation(ArchTest.class)).isEmpty();
        }
        catch (Exception | NoClassDefFoundError e) {
            return false;
        }
    }

    private URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new ArchTestInitializationException(e);
        }
    }

    protected ArchUnitEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        return new ArchUnitEngineExecutionContext();
    }

    static class SharedCache {
        private static final ClassCache cache = new ClassCache();

        SharedCache() {
        }

        ClassCache get() {
            return cache;
        }
    }
}

