/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.junit.AbstractArchUnitTestDescriptor;
import com.tngtech.archunit.junit.AnalyzeClasses;
import com.tngtech.archunit.junit.ArchRules;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.junit.ArchTestInitializationException;
import com.tngtech.archunit.junit.ArchTests;
import com.tngtech.archunit.junit.ArchUnitEngineExecutionContext;
import com.tngtech.archunit.junit.CacheMode;
import com.tngtech.archunit.junit.ClassAnalysisRequest;
import com.tngtech.archunit.junit.ClassCache;
import com.tngtech.archunit.junit.CreatesChildren;
import com.tngtech.archunit.junit.DisplayNameResolver;
import com.tngtech.archunit.junit.ElementResolver;
import com.tngtech.archunit.junit.FieldSource;
import com.tngtech.archunit.junit.LocationProvider;
import com.tngtech.archunit.junit.ReflectionUtils;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArchUnitTestDescriptor
extends AbstractArchUnitTestDescriptor
implements CreatesChildren {
    private static final Logger LOG = LoggerFactory.getLogger(ArchUnitTestDescriptor.class);
    static final String CLASS_SEGMENT_TYPE = "class";
    static final String FIELD_SEGMENT_TYPE = "field";
    static final String METHOD_SEGMENT_TYPE = "method";
    private final Class<?> testClass;
    private ClassCache classCache;

    private ArchUnitTestDescriptor(ElementResolver resolver, Class<?> testClass, ClassCache classCache) {
        super(resolver.getUniqueId(), testClass.getSimpleName(), (TestSource)ClassSource.from(testClass), testClass);
        this.testClass = testClass;
        this.classCache = classCache;
    }

    static void resolve(TestDescriptor parent, ElementResolver resolver, ClassCache classCache) {
        resolver.resolveClass().ifRequestedAndResolved(CreatesChildren::createChildren).ifRequestedButUnresolved((clazz, childResolver) -> ArchUnitTestDescriptor.createTestDescriptor(parent, classCache, clazz, childResolver));
    }

    private static void createTestDescriptor(TestDescriptor parent, ClassCache classCache, Class<?> clazz, ElementResolver childResolver) {
        if (clazz.getAnnotation(AnalyzeClasses.class) == null) {
            LOG.warn("Class {} is not annotated with @{} and thus cannot run as a top level test. This warning can be ignored if {} is only used as part of a rules library included via {}.in({}.class).", new Object[]{clazz.getName(), AnalyzeClasses.class.getSimpleName(), clazz.getSimpleName(), ArchTests.class.getSimpleName(), clazz.getSimpleName()});
            return;
        }
        ArchUnitTestDescriptor classDescriptor = new ArchUnitTestDescriptor(childResolver, clazz, classCache);
        parent.addChild((TestDescriptor)classDescriptor);
        classDescriptor.createChildren(childResolver);
    }

    @Override
    public void createChildren(ElementResolver resolver) {
        Supplier<JavaClasses> classes = () -> this.classCache.getClassesToAnalyzeFor(this.testClass, new JUnit5ClassAnalysisRequest(this.testClass));
        ReflectionUtils.getAllFields(this.testClass, ReflectionUtils.withAnnotation(ArchTest.class)).forEach(field -> this.resolveField(resolver, classes, (Field)field));
        ReflectionUtils.getAllMethods(this.testClass, ReflectionUtils.withAnnotation(ArchTest.class)).forEach(method -> this.resolveMethod(resolver, classes, (Method)method));
    }

    private void resolveField(ElementResolver resolver, Supplier<JavaClasses> classes, Field field) {
        resolver.resolveField(field).ifUnresolved(childResolver -> ArchUnitTestDescriptor.resolveChildren((TestDescriptor)this, childResolver, field, classes));
    }

    private void resolveMethod(ElementResolver resolver, Supplier<JavaClasses> classes, Method method) {
        resolver.resolveMethod(method).ifUnresolved(childResolver -> this.addChild((TestDescriptor)new ArchUnitMethodDescriptor(this.getUniqueId(), method, classes)));
    }

    private static void resolveChildren(TestDescriptor parent, ElementResolver resolver, Field field, Supplier<JavaClasses> classes) {
        if (ArchTests.class.isAssignableFrom(field.getType()) || ArchRules.class.isAssignableFrom(field.getType())) {
            ArchUnitTestDescriptor.resolveArchRules(parent, resolver, field, classes);
        } else {
            parent.addChild((TestDescriptor)new ArchUnitRuleDescriptor(resolver.getUniqueId(), (ArchRule)ArchUnitTestDescriptor.getValue(field), classes, field));
        }
    }

    private static <T> T getValue(Field field) {
        return ReflectionUtils.getValueOrThrowException(field, field.getDeclaringClass(), ArchTestInitializationException.WRAP_CAUSE);
    }

    private static void resolveArchRules(TestDescriptor parent, ElementResolver resolver, Field field, Supplier<JavaClasses> classes) {
        DeclaredArchTests archTests = ArchUnitTestDescriptor.getDeclaredArchTests(field);
        resolver.resolveClass(archTests.getDefinitionLocation()).ifRequestedAndResolved(CreatesChildren::createChildren).ifRequestedButUnresolved((clazz, childResolver) -> {
            ArchUnitArchTestsDescriptor rulesDescriptor = new ArchUnitArchTestsDescriptor((ElementResolver)childResolver, archTests, classes, field);
            parent.addChild((TestDescriptor)rulesDescriptor);
            rulesDescriptor.createChildren((ElementResolver)childResolver);
        });
    }

    private static DeclaredArchTests getDeclaredArchTests(Field field) {
        return new DeclaredArchTests(ArchTests.from(ArchUnitTestDescriptor.getValue(field)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public void after(ArchUnitEngineExecutionContext context) {
        this.classCache.clear(this.testClass);
    }

    private static class ArchUnitRuleDescriptor
    extends AbstractArchUnitTestDescriptor {
        private final ArchRule rule;
        private final Supplier<JavaClasses> classes;

        ArchUnitRuleDescriptor(UniqueId uniqueId, ArchRule rule, Supplier<JavaClasses> classes, Field field) {
            super(uniqueId, DisplayNameResolver.determineDisplayName(field.getName()), (TestSource)FieldSource.from((Field)field), field);
            this.rule = rule;
            this.classes = classes;
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }

        public ArchUnitEngineExecutionContext execute(ArchUnitEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
            this.rule.check(this.classes.get());
            return context;
        }
    }

    private static class DeclaredArchTests {
        private final ArchTests archTests;

        DeclaredArchTests(ArchTests archTests) {
            this.archTests = archTests;
        }

        Class<?> getDefinitionLocation() {
            return this.archTests.getDefinitionLocation();
        }

        String getDisplayName() {
            return this.archTests.getDefinitionLocation().getSimpleName();
        }

        void handleFields(Consumer<? super Field> doWithField) {
            ReflectionUtils.getAllFields(this.archTests.getDefinitionLocation(), ReflectionUtils.withAnnotation(ArchTest.class)).forEach(doWithField);
        }

        void handleMethods(Consumer<? super Method> doWithMethod) {
            ReflectionUtils.getAllMethods(this.archTests.getDefinitionLocation(), ReflectionUtils.withAnnotation(ArchTest.class)).forEach(doWithMethod);
        }
    }

    private static class ArchUnitArchTestsDescriptor
    extends AbstractArchUnitTestDescriptor
    implements CreatesChildren {
        private final DeclaredArchTests archTests;
        private final Supplier<JavaClasses> classes;

        ArchUnitArchTestsDescriptor(ElementResolver resolver, DeclaredArchTests archTests, Supplier<JavaClasses> classes, Field field) {
            super(resolver.getUniqueId(), archTests.getDisplayName(), (TestSource)ClassSource.from(archTests.getDefinitionLocation()), field, archTests.getDefinitionLocation());
            this.archTests = archTests;
            this.classes = classes;
        }

        @Override
        public void createChildren(ElementResolver resolver) {
            this.archTests.handleFields(field -> resolver.resolve(ArchUnitTestDescriptor.FIELD_SEGMENT_TYPE, field.getName(), childResolver -> ArchUnitTestDescriptor.resolveChildren((TestDescriptor)this, childResolver, field, this.classes)));
            this.archTests.handleMethods(method -> resolver.resolve(ArchUnitTestDescriptor.METHOD_SEGMENT_TYPE, method.getName(), childResolver -> this.addChild((TestDescriptor)new ArchUnitMethodDescriptor(this.getUniqueId(), (Method)method, this.classes))));
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.CONTAINER;
        }
    }

    private static class ArchUnitMethodDescriptor
    extends AbstractArchUnitTestDescriptor {
        private final Method method;
        private final Supplier<JavaClasses> classes;

        ArchUnitMethodDescriptor(UniqueId uniqueId, Method method, Supplier<JavaClasses> classes) {
            super(uniqueId.append(ArchUnitTestDescriptor.METHOD_SEGMENT_TYPE, method.getName()), DisplayNameResolver.determineDisplayName(method.getName()), (TestSource)MethodSource.from((Method)method), method);
            this.validate(method);
            this.method = method;
            this.classes = classes;
            this.method.setAccessible(true);
        }

        private void validate(Method method) {
            ArchTestInitializationException.check(method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JavaClasses.class), "@%s Method %s.%s must have exactly one parameter of type %s", ArchTest.class.getSimpleName(), method.getDeclaringClass().getSimpleName(), method.getName(), JavaClasses.class.getName());
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }

        public ArchUnitEngineExecutionContext execute(ArchUnitEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
            ReflectionUtils.invokeMethod(this.method, this.method.getDeclaringClass(), this.classes.get());
            return context;
        }
    }

    private static class JUnit5ClassAnalysisRequest
    implements ClassAnalysisRequest {
        private final AnalyzeClasses analyzeClasses;

        JUnit5ClassAnalysisRequest(Class<?> testClass) {
            this.analyzeClasses = JUnit5ClassAnalysisRequest.checkAnnotation(testClass);
        }

        private static AnalyzeClasses checkAnnotation(Class<?> testClass) {
            AnalyzeClasses analyzeClasses = testClass.getAnnotation(AnalyzeClasses.class);
            Preconditions.checkArgument((analyzeClasses != null ? 1 : 0) != 0, (String)"Class %s must be annotated with @%s", (Object)testClass.getSimpleName(), (Object)AnalyzeClasses.class.getSimpleName());
            return analyzeClasses;
        }

        @Override
        public String[] getPackageNames() {
            return this.analyzeClasses.packages();
        }

        @Override
        public Class<?>[] getPackageRoots() {
            return this.analyzeClasses.packagesOf();
        }

        @Override
        public Class<? extends LocationProvider>[] getLocationProviders() {
            return this.analyzeClasses.locations();
        }

        @Override
        public Class<? extends ImportOption>[] getImportOptions() {
            return this.analyzeClasses.importOptions();
        }

        @Override
        public CacheMode getCacheMode() {
            return this.analyzeClasses.cacheMode();
        }
    }
}

