/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.base.Optional;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final Config INSTANCE = new Config();

    public static Config config() {
        return INSTANCE;
    }

    public boolean isReportEnabled() {
        return System.getProperty("jgiven.report.enabled", "true").equalsIgnoreCase("true");
    }

    public Optional<File> getReportDir() {
        File reportDir;
        String reportDirName = System.getProperty("jgiven.report.dir");
        if (reportDirName == null) {
            reportDirName = "jgiven-reports";
            log.info("jgiven.report.dir not set, using default value jgiven-reports");
        }
        if ((reportDir = new File(reportDirName)).exists() && !reportDir.isDirectory()) {
            log.warn(reportDirName + " exists but is not a directory. Will not generate JGiven reports.");
            return Optional.absent();
        }
        log.info("Using folder " + reportDirName + " to store JGiven reports");
        return Optional.of((Object)reportDir);
    }

    public boolean textColorEnabled() {
        return System.getProperty("jgiven.report.text.color", "true").equalsIgnoreCase("true");
    }

    public boolean textReport() {
        return System.getProperty("jgiven.report.text", "true").equalsIgnoreCase("true");
    }
}

