/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.annotation.AfterScenario;
import com.tngtech.jgiven.annotation.AfterStage;
import com.tngtech.jgiven.annotation.BeforeScenario;
import com.tngtech.jgiven.annotation.BeforeStage;
import com.tngtech.jgiven.annotation.Hidden;
import com.tngtech.jgiven.annotation.IntroWord;
import com.tngtech.jgiven.annotation.ScenarioRule;
import com.tngtech.jgiven.annotation.ScenarioStage;
import com.tngtech.jgiven.impl.inject.ValueInjector;
import com.tngtech.jgiven.impl.intercept.NoOpScenarioListener;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.intercept.StepMethodHandler;
import com.tngtech.jgiven.impl.intercept.StepMethodInterceptor;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.integration.CanWire;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScenarioExecutor.class);
    private Object currentStage;
    private State state = State.INIT;
    private boolean beforeStepsWereExecuted;
    private Date startDate;
    private final AtomicInteger stackDepth = new AtomicInteger();
    private final Map<Class<?>, StageState> stages = Maps.newLinkedHashMap();
    private final List<Object> scenarioRules = Lists.newArrayList();
    private final ValueInjector injector = new ValueInjector();
    private ScenarioListener listener = new NoOpScenarioListener();

    public ScenarioExecutor() {
        this.injector.injectValueByType(ScenarioExecutor.class, this);
    }

    public <T> T addStage(Class<T> stepsClass) {
        if (this.stages.containsKey(stepsClass)) {
            return (T)this.stages.get(stepsClass).instance;
        }
        Enhancer e = new Enhancer();
        e.setSuperclass(stepsClass);
        StepMethodInterceptor callback = new StepMethodInterceptor(new MethodHandler(), this.stackDepth);
        e.setCallback((Callback)callback);
        Object result = e.create();
        callback.enable();
        this.stages.put(stepsClass, new StageState(result));
        this.gatherRules(result);
        this.injectSteps(result);
        return (T)result;
    }

    public void addIntroWord(String word) {
        this.listener.introWordAdded(word);
    }

    private void gatherRules(Object object) {
        ReflectionUtil.forEachField(object, object.getClass(), ReflectionUtil.hasAtLeastOneAnnotation(ScenarioRule.class), new ReflectionUtil.FieldAction(){

            @Override
            public void act(Object object, Field field) throws Exception {
                log.debug("Found rule in field: " + field);
                field.setAccessible(true);
                ScenarioExecutor.this.scenarioRules.add(field.get(object));
            }
        });
    }

    public <T> T when(T whenStage) {
        return this.update(whenStage);
    }

    private <T> T update(T t) {
        if (this.currentStage == t) {
            return t;
        }
        if (this.currentStage == null) {
            this.ensureBeforeStepsAreExecuted();
        } else {
            this.executeAfterStageMethods(this.currentStage);
            this.readScenarioState(this.currentStage);
        }
        this.injector.updateValues(t);
        StageState stageState = this.getStageState(t);
        if (!stageState.beforeStageCalled) {
            stageState.beforeStageCalled = true;
            this.executeBeforeStageSteps(t);
        }
        this.currentStage = t;
        return t;
    }

    private void executeAfterStageMethods(Object stage) {
        StageState stageState = this.getStageState(stage);
        if (stageState.afterStageCalled) {
            return;
        }
        stageState.afterStageCalled = true;
        this.executeAnnotatedMethods(stage, AfterStage.class);
    }

    StageState getStageState(Object stage) {
        return this.stages.get(stage.getClass().getSuperclass());
    }

    private void ensureBeforeStepsAreExecuted() {
        if (this.state != State.INIT) {
            return;
        }
        this.state = State.STARTED;
        this.startDate = new Date();
        try {
            for (Object rule : this.scenarioRules) {
                this.invokeRuleMethod(rule, "before");
            }
            this.beforeStepsWereExecuted = true;
            for (StageState stage : this.stages.values()) {
                this.executeBeforeScenarioSteps(stage.instance);
            }
        }
        catch (Exception e) {
            this.finished();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void executeAnnotatedMethods(Object stage, Class<? extends Annotation> annotationClass) {
        log.debug("Executing methods annotated with @" + annotationClass.getName());
        ReflectionUtil.forEachMethod(stage, stage.getClass(), annotationClass, new ReflectionUtil.MethodAction(){

            @Override
            public void act(Object object, Method method) throws Exception {
                log.debug("Executing method " + method);
                method.setAccessible(true);
                method.invoke(object, new Object[0]);
            }
        });
    }

    private void invokeRuleMethod(Object rule, String methodName) {
        Optional<Method> optionalMethod = ReflectionUtil.findMethodTransitively(rule.getClass(), methodName);
        if (!optionalMethod.isPresent()) {
            log.debug("Class " + rule.getClass() + " has no " + methodName + " method, but was used as ScenarioRule!");
        }
        log.debug("Executing method " + methodName + " of rule class " + rule.getClass());
        ((Method)optionalMethod.get()).setAccessible(true);
        try {
            ((Method)optionalMethod.get()).invoke(rule, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    void executeBeforeStageSteps(Object stage) {
        this.executeAnnotatedMethods(stage, BeforeStage.class);
    }

    private void executeBeforeScenarioSteps(Object stage) {
        this.executeAnnotatedMethods(stage, BeforeScenario.class);
    }

    public <T> void injectValueByType(Class<T> clazz, T idGenerator) {
        this.injector.injectValueByType(clazz, idGenerator);
    }

    public void readScenarioState(Object object) {
        this.injector.readValues(object);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void wireSteps(CanWire canWire) {
        for (StageState steps : this.stages.values()) {
            canWire.wire(steps.instance);
        }
    }

    public void finished() {
        if (this.state == State.FINISHED) {
            return;
        }
        if (this.state != State.STARTED) {
            throw new IllegalStateException("The Scenario must be in state STARTED in order to finish it, but it is in state " + (Object)((Object)this.state));
        }
        this.state = State.FINISHED;
        Exception lastThrownException = null;
        if (this.beforeStepsWereExecuted) {
            for (StageState stage : Lists.reverse((List)Lists.newArrayList(this.stages.values()))) {
                try {
                    this.executeAnnotatedMethods(stage.instance, AfterScenario.class);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    lastThrownException = e;
                }
            }
        }
        for (Object rule : Lists.reverse(this.scenarioRules)) {
            try {
                this.invokeRuleMethod(rule, "after");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                lastThrownException = e;
            }
        }
        if (lastThrownException != null) {
            new RuntimeException("Exception occurred during the execution of after methods", lastThrownException);
        }
    }

    public void injectSteps(Object object) {
        ReflectionUtil.forEachField(object, object.getClass(), ReflectionUtil.hasAtLeastOneAnnotation(ScenarioStage.class), new ReflectionUtil.FieldAction(){

            @Override
            public void act(Object object, Field field) throws Exception {
                field.setAccessible(true);
                Class<?> type = field.getType();
                Object steps = ScenarioExecutor.this.addStage(type);
                field.set(object, steps);
            }
        });
    }

    public void succeeded() {
        this.listener.scenarioSucceeded();
    }

    public void failed(Throwable e) {
        this.listener.scenarioFailed(e);
    }

    public void startScenario(String description) {
        this.listener.scenarioStarted(description);
    }

    public void startScenario(Method method, List<?> arguments) {
        this.listener.scenarioStarted(method, arguments);
    }

    public void setListener(ScenarioListener listener) {
        this.listener = listener;
    }

    class MethodHandler
    implements StepMethodHandler {
        MethodHandler() {
        }

        @Override
        public void handleMethod(Object stageInstance, Method paramMethod, Object[] arguments) {
            if (paramMethod.isSynthetic()) {
                return;
            }
            if (paramMethod.isAnnotationPresent(AfterStage.class) || paramMethod.isAnnotationPresent(BeforeStage.class) || paramMethod.isAnnotationPresent(BeforeScenario.class) || paramMethod.isAnnotationPresent(AfterScenario.class) || paramMethod.isAnnotationPresent(Hidden.class)) {
                return;
            }
            ScenarioExecutor.this.update(stageInstance);
            if (paramMethod.isAnnotationPresent(IntroWord.class)) {
                ScenarioExecutor.this.listener.introWordAdded(paramMethod.getName());
            } else {
                ScenarioExecutor.this.listener.stepMethodInvoked(paramMethod, Arrays.asList(arguments));
            }
        }

        @Override
        public void handleThrowable(Throwable t) {
            ScenarioExecutor.this.failed(t);
            ScenarioExecutor.this.finished();
        }
    }

    static class StageState {
        final Object instance;
        boolean afterStageCalled;
        boolean beforeStageCalled;

        StageState(Object instance) {
            this.instance = instance;
        }
    }

    public static enum State {
        INIT,
        STARTED,
        FINISHED;

    }
}

