/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.intercept;

import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.impl.intercept.StepMethodHandler;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StepMethodInterceptor.class);
    private final StepMethodHandler scenarioMethodHandler;
    private final AtomicInteger stackDepth;
    private boolean enabled;

    public StepMethodInterceptor(StepMethodHandler scenarioMethodHandler, AtomicInteger stackDepth) {
        this.scenarioMethodHandler = scenarioMethodHandler;
        this.stackDepth = stackDepth;
    }

    public Object intercept(Object receiver, Method method, Object[] parameters, MethodProxy methodProxy) throws Throwable {
        if (this.enabled && this.stackDepth.get() == 0 && !method.getDeclaringClass().equals(Object.class)) {
            this.scenarioMethodHandler.handleMethod(receiver, method, parameters);
        }
        if (method.isAnnotationPresent(NotImplementedYet.class) || receiver.getClass().isAnnotationPresent(NotImplementedYet.class)) {
            if (!method.getReturnType().isAssignableFrom(receiver.getClass())) {
                log.warn("The step method " + method.getName() + " of class " + method.getDeclaringClass().getSimpleName() + " does not follow the fluent interface convention of returning " + "the receiver object. Please change the return type to the SELF type parameter.");
                return null;
            }
            return receiver;
        }
        try {
            this.stackDepth.incrementAndGet();
            Object object = methodProxy.invokeSuper(receiver, parameters);
            return object;
        }
        catch (Throwable t) {
            this.scenarioMethodHandler.handleThrowable(t);
            throw t;
        }
        finally {
            this.stackDepth.decrementAndGet();
        }
    }

    public void enable() {
        this.enabled = true;
    }
}

