/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.util;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtil {
    public static void forEachField(final Object object, Class<?> clazz, final FieldPredicate predicate, final FieldAction action) {
        ReflectionUtil.forEachSuperClass(clazz, new ClassAction(){

            @Override
            public void act(Class<?> clazz) throws Exception {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!predicate.isTrue(field)) continue;
                    action.act(object, field);
                }
            }
        });
    }

    public static void forEachMethod(final Object object, Class<?> clazz, final Class<? extends Annotation> annotation, final MethodAction action) {
        ReflectionUtil.forEachSuperClass(clazz, new ClassAction(){

            @Override
            public void act(Class<?> clazz) throws Exception {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    action.act(object, method);
                }
            }
        });
    }

    public static void forEachSuperClass(Class<?> clazz, ClassAction action) {
        try {
            action.act(clazz);
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                ReflectionUtil.forEachSuperClass(superclass, action);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static FieldPredicate hasAtLeastOneAnnotation(final Class<? extends Annotation> ... annotation) {
        return new FieldPredicate(){

            @Override
            public boolean isTrue(Field field) throws Exception {
                for (Class clazz : annotation) {
                    if (!field.isAnnotationPresent(clazz)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static FieldPredicate allFields() {
        return new FieldPredicate(){

            @Override
            public boolean isTrue(Field field) throws Exception {
                return true;
            }
        };
    }

    public static Optional<Method> findMethodTransitively(Class<?> clazz, String methodName) {
        if (clazz == null) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)clazz.getDeclaredMethod(methodName, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return ReflectionUtil.findMethodTransitively(clazz.getSuperclass(), methodName);
        }
    }

    public static Method findMethod(Class<?> testClass, String methodName) {
        Method method = null;
        for (Method m : testClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Could not find method with name " + methodName);
        }
        return method;
    }

    public static interface MethodAction {
        public void act(Object var1, Method var2) throws Exception;
    }

    public static interface FieldAction {
        public void act(Object var1, Field var2) throws Exception;
    }

    public static interface ClassAction {
        public void act(Class<?> var1) throws Exception;
    }

    public static interface FieldPredicate {
        public boolean isTrue(Field var1) throws Exception;
    }
}

