/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.FilePredicates;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.html.HtmlWriterUtils;
import com.tngtech.jgiven.report.json.ScenarioJsonReader;
import com.tngtech.jgiven.report.model.ReportModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHtmlReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractHtmlReportGenerator.class);
    protected File toDir;
    protected PrintWriter writer;
    protected HtmlWriterUtils utils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(File toDir, String targetFileName, File sourceDir) throws IOException {
        if (!toDir.isDirectory()) {
            throw new RuntimeException(toDir + " is not existing or is not a directory");
        }
        log.info("Generating file " + targetFileName + " to directory " + toDir);
        this.toDir = toDir;
        this.writer = new PrintWriter(new File(toDir, targetFileName), Charsets.UTF_8.name());
        this.utils = new HtmlWriterUtils(this.writer);
        try {
            this.writeStart();
            for (ReportModelFile f : Files.fileTreeTraverser().breadthFirstTraversal((Object)sourceDir).filter(FilePredicates.endsWith(".json")).transform((Function)new TestCaseFileReader())) {
                this.handleReportModel(f.model, f.file);
            }
            this.writeEnd();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(this.writer);
            throw throwable;
        }
        ResourceUtil.close(this.writer);
        this.copyFileToTargetDir("style.css");
        this.copyFileToTargetDir("default.css");
    }

    public void writeStart() {
        this.utils.writeHtmlHeader("JGiven HTML Report");
        this.writer.println("<div class='linklist'>");
        this.writer.println("<h1>Acceptance Tests</h1><ul>");
    }

    public void writeEnd() {
        this.writer.println("</ul></div></body></html>");
    }

    public abstract void handleReportModel(ReportModel var1, File var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFileToTargetDir(String fileName) throws FileNotFoundException, IOException {
        InputStream stream = this.getClass().getResourceAsStream("/com/tngtech/jgiven/report/html/" + fileName);
        File file = new File(this.toDir, fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ByteStreams.copy((InputStream)stream, (OutputStream)fileOutputStream);
        }
        finally {
            stream.close();
            fileOutputStream.close();
        }
    }

    public static class TestCaseFileReader
    implements Function<File, ReportModelFile> {
        public ReportModelFile apply(File file) {
            ReportModelFile result = new ReportModelFile();
            result.file = file;
            result.model = new ScenarioJsonReader().apply(file);
            return result;
        }
    }

    public static class ReportModelFile {
        public ReportModel model;
        public File file;
    }
}

