/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.tngtech.jgiven.report.html.AbstractHtmlReportGenerator;
import com.tngtech.jgiven.report.html.HtmlFileWriter;
import com.tngtech.jgiven.report.model.ReportModel;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameBasedHtmlReportGenerator
extends AbstractHtmlReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(FrameBasedHtmlReportGenerator.class);
    static final String LINKS_FILE_NAME = "links.html";
    static final String TESTCLASSES_FRAME_NAME = "testclasses";
    private final List<ModelFile> models = Lists.newArrayList();

    public void generate(File toDir, File sourceDir) throws IOException {
        this.generate(toDir, LINKS_FILE_NAME, sourceDir);
        this.copyFileToTargetDir("index.html");
    }

    @Override
    public void handleReportModel(ReportModel model, File file) {
        String targetFileName = Files.getNameWithoutExtension((String)file.getName()) + ".html";
        File targetFile = new File(this.toDir, targetFileName);
        log.debug("Writing to file " + targetFile);
        try {
            HtmlFileWriter.writeModelToFile(model, targetFile);
            ModelFile modelFile = new ModelFile();
            modelFile.model = model;
            modelFile.file = targetFile;
            this.models.add(modelFile);
        }
        catch (Exception e) {
            log.error("Error while trying to write to file " + file + ". " + e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void writeEnd() {
        Comparator<ModelFile> comparator = new Comparator<ModelFile>(){

            @Override
            public int compare(ModelFile o1, ModelFile o2) {
                return o1.model.getSimpleClassName().compareTo(o2.model.getSimpleClassName());
            }
        };
        Collections.sort(this.models, comparator);
        for (ModelFile modelFile : this.models) {
            this.writeFileLink(modelFile);
        }
    }

    private void writeFileLink(ModelFile model) {
        this.writer.println(String.format("<li><a href='%s' target='%s'>%s</a>", model.file.getName(), TESTCLASSES_FRAME_NAME, model.model.getSimpleClassName()));
    }

    static class ModelFile {
        ReportModel model;
        File file;

        ModelFile() {
        }
    }
}

