/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.base.Throwables;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.html.HtmlWriter;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class HtmlFileWriter
extends HtmlWriter
implements Closeable {
    protected final File file;

    public HtmlFileWriter(File file) {
        super(HtmlFileWriter.getPrintWriter(file));
        this.file = file;
    }

    private static PrintWriter getPrintWriter(File file) {
        try {
            return new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModelToFile(ReportModel model, File file) {
        PrintWriter printWriter = HtmlFileWriter.getPrintWriter(file);
        try {
            HtmlWriter htmlWriter = new HtmlWriter(printWriter);
            htmlWriter.writeHtmlHeader(model.className);
            htmlWriter.write(model);
            htmlWriter.writeHtmlFooter();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeScenarioModelToFile(ScenarioModel model, File file) {
        PrintWriter printWriter = HtmlFileWriter.getPrintWriter(file);
        try {
            new HtmlWriter(printWriter).write(model);
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
    }
}

