/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.io.Files;
import com.tngtech.jgiven.report.html.FrameBasedHtmlReportGenerator;
import com.tngtech.jgiven.report.html.SingleFileHtmlReportGenerator;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(HtmlReportGenerator.class);
    public File sourceDir = new File(".");
    public File toDir = new File(".");
    public boolean frames = false;
    public File customCssFile = null;

    public static void main(String ... args) throws IOException {
        HtmlReportGenerator generator = new HtmlReportGenerator();
        for (String arg : args) {
            if (arg.equals("-h") || arg.equals("--help")) {
                HtmlReportGenerator.printUsageAndExit();
                continue;
            }
            if (arg.startsWith("--dir=")) {
                generator.sourceDir = new File(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("--todir=")) {
                generator.toDir = new File(arg.split("=")[1]);
                continue;
            }
            if (arg.equals("--frames")) {
                generator.frames = true;
                continue;
            }
            if (arg.startsWith("--customcss=")) {
                generator.customCssFile = new File(arg.split("=")[1]);
                continue;
            }
            HtmlReportGenerator.printUsageAndExit();
        }
        generator.generate();
    }

    public void generate() throws IOException {
        if (!this.toDir.exists() && !this.toDir.mkdirs()) {
            log.error("Could not create target directory " + this.toDir);
            return;
        }
        if (this.frames) {
            new FrameBasedHtmlReportGenerator().generate(this.toDir, this.sourceDir);
        } else {
            new FrameBasedHtmlReportGenerator().generate(this.toDir, this.sourceDir);
            new SingleFileHtmlReportGenerator().generate(this.toDir, "alltestcases.html", this.sourceDir);
        }
        if (this.customCssFile != null) {
            if (!this.customCssFile.canRead()) {
                log.info("Cannot read customCssFile " + this.customCssFile + " skipping");
            } else {
                Files.copy((File)this.customCssFile, (File)new File(this.toDir, "custom.css"));
            }
        }
    }

    private static void printUsageAndExit() {
        System.err.println("Options: [--frames] [--dir=<dir>] [--todir=<dir>] [--customcss=<cssfile>]");
        System.exit(1);
    }
}

