/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.io.Files;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.html.HtmlWriterUtils;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Tag;
import com.tngtech.jgiven.report.model.Word;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class HtmlWriter
extends ReportModelVisitor {
    protected final PrintWriter writer;
    protected final HtmlWriterUtils utils;
    protected ScenarioModel scenarioModel;
    private ScenarioCaseModel scenarioCase;

    public HtmlWriter(PrintWriter writer) {
        this.writer = writer;
        this.utils = new HtmlWriterUtils(writer);
    }

    public void writeHtmlHeader(String title) {
        this.utils.writeHtmlHeader(title);
    }

    public void writeHtmlFooter() {
        this.writer.write("</body></html>");
    }

    public void write(ScenarioModel model) {
        this.writeHtmlHeader(model.className);
        model.accept(this);
        this.writeHtmlFooter();
    }

    public void write(ReportModel model) {
        model.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ScenarioModel model) {
        String string;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(stream);
        try {
            new HtmlWriter(printWriter).write(model);
            printWriter.flush();
            string = stream.toString();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
        return string;
    }

    @Override
    public void visit(ReportModel reportModel) {
        this.writer.println("<div class='testcase'>");
        this.writer.println("<div class='testcase-header'>");
        this.writer.println(String.format("<div class='packagename'>%s</div>", Files.getNameWithoutExtension((String)reportModel.className)));
        this.writer.println(String.format("<h2>%s</h2>", Files.getFileExtension((String)reportModel.className)));
        this.writer.println("</div>");
        this.writer.println("<div class='testcase-content'>");
    }

    @Override
    public void visitEnd(ReportModel reportModel) {
        this.writer.append("</div>");
        this.writer.append("</div>");
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        this.scenarioModel = scenarioModel;
        this.writer.print(String.format("<div class='scenario'><h3>%s", WordUtil.capitalize(scenarioModel.description)));
        for (Tag tag : scenarioModel.tags) {
            this.printTag(tag);
        }
        this.writer.println("</h3>");
    }

    private void printTag(Tag tag) {
        if (tag.value != null) {
            this.printTag(tag.name, tag.value + "");
        } else {
            this.printTag(tag.name, "");
        }
    }

    private void printTag(String tagName, String tagValue) {
        this.writer.print(String.format("<div class='tag tag-%s'>%s</div>", tagName, tagValue));
    }

    @Override
    public void visitEnd(ScenarioModel scenarioModel) {
        this.writer.println("</div>");
    }

    @Override
    public void visit(ScenarioCaseModel scenarioCase) {
        this.writer.println(String.format("<div class='case %sCase'>", scenarioCase.success ? "passed" : "failed"));
        this.scenarioCase = scenarioCase;
        if (!scenarioCase.arguments.isEmpty()) {
            this.writer.println(String.format("<h4>Case %d: ", scenarioCase.caseNr));
            for (int i = 0; i < scenarioCase.arguments.size(); ++i) {
                if (this.scenarioModel.parameterNames.size() > i) {
                    this.writer.print(this.scenarioModel.parameterNames.get(i) + " = ");
                }
                this.writer.print(scenarioCase.arguments.get(i));
                if (i >= scenarioCase.arguments.size() - 1) continue;
                this.writer.println(", ");
            }
            this.writer.println("</h4>");
        }
        this.writer.println("<ul class='steps'>");
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.success) {
            this.writer.println("<div class='passed'>Passed</div>");
        } else {
            this.writer.println("<div class='failed'>Failed: " + scenarioCase.errorMessage + "</div>");
        }
        this.writer.println("</ul>");
        this.writer.println("</div><!-- case -->");
    }

    @Override
    public void visit(StepModel stepModel) {
        this.writer.print("<li>");
        boolean firstWord = true;
        for (Word word : stepModel.words) {
            if (!firstWord) {
                this.writer.print(' ');
            }
            String text = word.value;
            if (firstWord && word.isIntroWord) {
                this.writer.print(String.format("<span class='introWord'>%s</span>", WordUtil.capitalize(text)));
            } else if (word.isArg) {
                if (this.scenarioCase.arguments.contains(word.value)) {
                    this.writer.print(String.format("<span class='caseArgument'>%s</span>", text));
                } else {
                    this.writer.print(String.format("<span class='argument'>%s</span>", text));
                }
            } else {
                this.writer.print(text);
            }
            firstWord = false;
        }
        this.writer.println("</li>");
    }
}

