/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.json;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.tngtech.jgiven.report.model.ReportModel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioJsonWriter {
    private static final Logger log = LoggerFactory.getLogger(ScenarioJsonWriter.class);
    private final ReportModel model;

    public ScenarioJsonWriter(ReportModel model) {
        this.model = model;
    }

    public void write(File file) {
        String json = this.toString();
        try {
            Files.write((CharSequence)json, (File)file, (Charset)Charsets.UTF_8);
            log.debug("Written JSON to file {}, {}", (Object)file, (Object)json);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this.model);
    }

    public void write(OutputStream stream) {
        new PrintWriter(stream).append(this.toString()).close();
    }
}

