/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.ParameterNamesNotFoundException;
import com.thoughtworks.paranamer.Paranamer;
import com.tngtech.jgiven.annotation.Format;
import com.tngtech.jgiven.annotation.Formatf;
import com.tngtech.jgiven.annotation.IsTag;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.ScenarioDescription;
import com.tngtech.jgiven.format.ArgumentFormatter;
import com.tngtech.jgiven.format.PrintfFormatter;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.util.WordUtil;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepFormatter;
import com.tngtech.jgiven.report.model.Tag;
import com.tngtech.jgiven.report.model.Word;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportModelBuilder
implements ScenarioListener {
    private static final Logger log = LoggerFactory.getLogger(ReportModelBuilder.class);
    private static final Paranamer paranamer = new BytecodeReadingParanamer();
    private ScenarioModel lastScenarioModel;
    private ScenarioCaseModel currentScenarioCase;
    private ReportModel scenarioCollectionModel;
    private Word introWord;

    public ReportModelBuilder() {
        this(new ReportModel());
    }

    public ReportModelBuilder(ReportModel scenarioCollectionModel) {
        this.setModel(scenarioCollectionModel);
    }

    public void setModel(ReportModel scenarioCollectionModel) {
        this.scenarioCollectionModel = scenarioCollectionModel;
    }

    @Override
    public void scenarioStarted(String description) {
        String readableDescription = description;
        if (description.contains("_")) {
            readableDescription = description.replace('_', ' ');
        } else if (!description.contains(" ")) {
            readableDescription = this.camelCaseToReadableText(description);
        }
        this.currentScenarioCase = new ScenarioCaseModel();
        if (!this.scenarioCollectionModel.scenarios.isEmpty()) {
            ScenarioModel scenarioModel = this.scenarioCollectionModel.scenarios.get(this.scenarioCollectionModel.scenarios.size() - 1);
            if (scenarioModel.description.equals(readableDescription)) {
                this.lastScenarioModel = scenarioModel;
            }
        }
        if (this.lastScenarioModel == null) {
            this.lastScenarioModel = new ScenarioModel();
            this.lastScenarioModel.className = this.scenarioCollectionModel.className;
            this.scenarioCollectionModel.scenarios.add(this.lastScenarioModel);
        }
        this.lastScenarioModel.addCase(this.currentScenarioCase);
        this.lastScenarioModel.description = readableDescription;
    }

    private String camelCaseToReadableText(String camelCase) {
        String scenarioDescription = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, camelCase).replace('_', ' ');
        return WordUtil.capitalize(scenarioDescription);
    }

    public void writeScenarioCase(ScenarioCaseModel scenarioCase) {
        this.currentScenarioCase = scenarioCase;
    }

    public void addStepMethod(Method paramMethod, List<Object> arguments) {
        boolean notImplementedYet;
        String name = ReportModelBuilder.nameWithoutUnderlines(paramMethod);
        List<StepFormatter.Formatting<?>> formatters = this.getFormatters(paramMethod.getParameterAnnotations());
        List<Word> words = new StepFormatter(name, arguments, formatters).buildFormattedWords();
        boolean bl = notImplementedYet = paramMethod.isAnnotationPresent(NotImplementedYet.class) || paramMethod.getDeclaringClass().isAnnotationPresent(NotImplementedYet.class);
        if (this.introWord != null) {
            words.add(0, this.introWord);
            this.introWord = null;
        }
        this.writeStep(name, words, notImplementedYet);
    }

    @Override
    public void introWordAdded(String fillWord) {
        this.introWord = new Word();
        this.introWord.isIntroWord = true;
        this.introWord.value = fillWord;
    }

    private List<StepFormatter.Formatting<?>> getFormatters(Annotation[][] parameterAnnotations) {
        ArrayList res = Lists.newArrayList();
        for (Annotation[] annotations : parameterAnnotations) {
            res.add(this.getFormatting(annotations));
        }
        return res;
    }

    private StepFormatter.Formatting<?> getFormatting(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            try {
                if (annotation instanceof Format) {
                    Format arg = (Format)annotation;
                    return new StepFormatter.Formatting(arg.value().newInstance(), arg.args());
                }
                if (!(annotation instanceof Formatf)) continue;
                Formatf arg = (Formatf)annotation;
                return new StepFormatter.Formatting((ArgumentFormatter)PrintfFormatter.class.newInstance(), arg.value());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void writeStep(String name, List<Word> words, boolean notImplementedYet) {
        this.getCurrentScenarioCase().addStep(name, words, notImplementedYet);
    }

    private ScenarioCaseModel getCurrentScenarioCase() {
        if (this.currentScenarioCase == null) {
            this.scenarioStarted("An Undescribed Scenario");
        }
        return this.currentScenarioCase;
    }

    @Override
    public void stepMethodInvoked(Method paramMethod, List<Object> arguments) {
        if (!this.isStepMethod(paramMethod)) {
            return;
        }
        this.addStepMethod(paramMethod, arguments);
    }

    public boolean isStepMethod(Method paramMethod) {
        return Modifier.isPublic(paramMethod.getModifiers());
    }

    public void setMethodName(String methodName) {
        this.lastScenarioModel.testMethodName = methodName;
    }

    public void addAnnotation(Tag tag) {
        this.lastScenarioModel.addTag(tag);
    }

    public void setCaseNr(int caseNr) {
        this.currentScenarioCase.caseNr = caseNr;
    }

    public void setArguments(List<String> arguments) {
        this.currentScenarioCase.arguments = arguments;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.lastScenarioModel.parameterNames = parameterNames;
    }

    public void setClassName(String name) {
        this.scenarioCollectionModel.className = name;
    }

    public void setSuccess(boolean b) {
        if (!this.currentScenarioCase.steps.isEmpty()) {
            this.currentScenarioCase.steps.get((int)(this.currentScenarioCase.steps.size() - 1)).failed = !b;
        }
        this.currentScenarioCase.success = b;
    }

    public void setErrorMessage(String message) {
        this.currentScenarioCase.errorMessage = message;
    }

    private static String nameWithoutUnderlines(Method paramMethod) {
        return paramMethod.getName().replace('_', ' ');
    }

    public ScenarioModel getCurrentScenarioModel() {
        return this.lastScenarioModel;
    }

    public ReportModel getScenarioCollectionModel() {
        return this.scenarioCollectionModel;
    }

    @Override
    public void scenarioFailed(Throwable e) {
        this.setSuccess(false);
        this.setErrorMessage(e.getMessage());
    }

    @Override
    public void scenarioSucceeded() {
        this.setSuccess(true);
    }

    @Override
    public void scenarioStarted(Method method, List<?> arguments) {
        this.readAnnotations(method);
        this.readParameterNames(method);
        this.setMethodName(method.getName());
        this.setArguments(this.toStringList(arguments));
    }

    private List<String> toStringList(List<?> arguments) {
        ArrayList result = Lists.newArrayList();
        for (Object o : arguments) {
            result.add("" + o);
        }
        return result;
    }

    private void readParameterNames(Method method) {
        try {
            this.setParameterNames(Arrays.asList(paranamer.lookupParameterNames((AccessibleObject)method)));
        }
        catch (ParameterNamesNotFoundException e) {
            log.warn("Could not determine parameter names for method " + method + ". You should compile your source code with debug information.");
        }
    }

    private void readAnnotations(Method method) {
        ScenarioAnnotations scenarioAnnotations = new ScenarioAnnotations();
        scenarioAnnotations.description = method.getName();
        if (method.isAnnotationPresent(ScenarioDescription.class)) {
            scenarioAnnotations.description = method.getAnnotation(ScenarioDescription.class).value();
        }
        this.scenarioStarted(scenarioAnnotations.description);
        if (this.currentScenarioCase.caseNr == 1) {
            this.addTags(scenarioAnnotations, method.getDeclaringClass().getAnnotations());
            this.addTags(scenarioAnnotations, method.getAnnotations());
        }
    }

    private void addTags(ScenarioAnnotations scenarioAnnotations, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            this.lastScenarioModel.tags.addAll(ReportModelBuilder.toTags(annotation));
        }
    }

    public static List<Tag> toTags(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        IsTag isTag = annotationType.getAnnotation(IsTag.class);
        if (isTag == null) {
            return Collections.emptyList();
        }
        Tag tag = new Tag();
        tag.name = annotationType.getSimpleName();
        try {
            Method method = annotationType.getMethod("value", new Class[0]);
            Object value = method.invoke((Object)annotation, new Object[0]);
            if (value != null) {
                if (value.getClass().isArray()) {
                    Object[] array = (Object[])value;
                    String[] stringArray = new String[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        stringArray[i] = array[i] + "";
                    }
                    if (isTag.explodeArray()) {
                        return ReportModelBuilder.getExplodedTags(annotationType.getSimpleName(), stringArray);
                    }
                    tag.value = stringArray;
                } else {
                    tag.value = value + "";
                }
            }
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (Exception e) {
            log.error("Error while getting 'value' method of annotation " + annotation, (Throwable)e);
        }
        return Arrays.asList(tag);
    }

    private static List<Tag> getExplodedTags(String tagName, String[] stringArray) {
        ArrayList result = Lists.newArrayList();
        for (String singleValue : stringArray) {
            Tag tag = new Tag();
            tag.name = tagName;
            tag.value = singleValue;
            result.add(tag);
        }
        return result;
    }

    static class ScenarioAnnotations {
        Set<String> tags = Sets.newHashSet();
        String description = "";

        ScenarioAnnotations() {
        }
    }
}

