/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.model.ImplementationStatus;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Tag;
import java.util.List;

public class ScenarioModel {
    public String className;
    public String testMethodName;
    public String description;
    public List<Tag> tags = Lists.newArrayList();
    public List<String> parameterNames = Lists.newArrayList();
    public List<ScenarioCaseModel> scenarioCases = Lists.newArrayList();

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
        for (ScenarioCaseModel scenarioCase : this.scenarioCases) {
            scenarioCase.accept(visitor);
        }
        visitor.visitEnd(this);
    }

    public void addCase(ScenarioCaseModel scenarioCase) {
        scenarioCase.caseNr = this.scenarioCases.size() + 1;
        this.scenarioCases.add(scenarioCase);
    }

    public ImplementationStatus getImplementationStatus() {
        return new ReportModelVisitor(){
            int implementedCount;
            int notImplementedCount;

            @Override
            public void visit(StepModel stepModel) {
                if (stepModel.notImplementedYet) {
                    ++this.notImplementedCount;
                } else {
                    ++this.implementedCount;
                }
            }

            public ImplementationStatus notFullyImplementedYet() {
                ScenarioModel.this.accept(this);
                if (this.implementedCount == 0) {
                    return ImplementationStatus.NONE;
                }
                if (this.notImplementedCount == 0) {
                    return ImplementationStatus.FINISHED;
                }
                return ImplementationStatus.PARTIALLY;
            }
        }.notFullyImplementedYet();
    }

    public ScenarioCaseModel getCase(int i) {
        return this.scenarioCases.get(i);
    }

    public void addTag(Tag tag) {
        this.tags.add(tag);
    }
}

