/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.format.ArgumentFormatter;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.report.model.Word;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StepFormatter {
    private final String stepDescription;
    private final List<?> arguments;
    private final List<Formatting<?>> formatters;

    public StepFormatter(String stepDescription, List<?> arguments, List<Formatting<?>> formatters) {
        this.stepDescription = stepDescription;
        this.arguments = arguments;
        this.formatters = formatters;
    }

    public List<Word> buildFormattedWords() {
        Object word;
        int i;
        ArrayList formattedWords = Lists.newArrayList();
        int argCount = 0;
        List words = Splitter.on((char)' ').splitToList((CharSequence)this.stepDescription);
        for (i = 0; i < words.size(); ++i) {
            word = (String)words.get(i);
            if (((String)word).startsWith("$")) {
                int argEnd = this.findArgumentEnd(i, words);
                this.formatArgument(formattedWords, argCount, (String)word, argEnd != -1);
                if (argEnd != -1) {
                    i = argEnd;
                }
                ++argCount;
                continue;
            }
            if (!formattedWords.isEmpty()) {
                Word previousWord = (Word)formattedWords.get(formattedWords.size() - 1);
                if (!previousWord.isArg) {
                    previousWord.append((String)word);
                    continue;
                }
                formattedWords.add(new Word((String)word));
                continue;
            }
            formattedWords.add(new Word((String)word));
        }
        for (i = argCount; i < this.arguments.size(); ++i) {
            word = new Word();
            ((Word)word).value = this.formatUsingFormatter(this.formatters.get(i), this.arguments.get(i));
            ((Word)word).isArg = true;
            formattedWords.add(word);
        }
        return formattedWords;
    }

    private int findArgumentEnd(int i, List<String> words) {
        for (int j = i; j < words.size(); ++j) {
            String word = words.get(j);
            if (!word.endsWith("$") || word.length() <= 1) continue;
            return j;
        }
        return -1;
    }

    private void formatArgument(List<Word> formattedWords, int argCount, String word, boolean isFreeTextArg) {
        Word w = new Word();
        w.isArg = true;
        Pattern pattern = Pattern.compile("\\$(\\d+)");
        Matcher matcher = pattern.matcher(word);
        int index = argCount;
        if (matcher.matches()) {
            int argIndex = Integer.parseInt(matcher.group(1));
            index = argIndex - 1;
        }
        w.value = this.formatUsingFormatter(this.formatters.get(index), this.arguments.get(index));
        if (w.value != null && !w.value.isEmpty()) {
            formattedWords.add(w);
        }
    }

    private <T> String formatUsingFormatter(Formatting<T> argumentFormatter, Object value) {
        if (argumentFormatter == null) {
            return new DefaultFormatter<Object>().format(value, new String[0]);
        }
        return argumentFormatter.format(value);
    }

    public static class Formatting<T> {
        private final ArgumentFormatter<T> formatter;
        private final String[] args;

        public Formatting(ArgumentFormatter<T> formatter, String ... args) {
            this.formatter = formatter;
            this.args = args;
        }

        public String format(T o) {
            return this.formatter.format(o, this.args);
        }
    }
}

