/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.collect.Lists;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.text.PlainTextReporter;
import java.util.ArrayList;
import java.util.List;

public class ExperimentalTablePlainTextReporter
extends PlainTextReporter {
    @Override
    public void visitEnd(ScenarioModel scenarioModel) {
        StringBuilder builder = new StringBuilder();
        List<Integer> columnWidths = this.getMaxColumnWidth(scenarioModel);
        for (int width : columnWidths) {
            builder.append("| %" + (width + 2) + "s ");
        }
        builder.append("|");
        String formatString = builder.toString();
        this.stream.println("Examples:\n");
        this.stream.println("  " + String.format(formatString, scenarioModel.parameterNames.toArray()));
        for (ScenarioCaseModel c : scenarioModel.scenarioCases) {
            this.stream.println("  " + String.format(formatString, c.arguments.toArray()));
        }
    }

    private List<Integer> getMaxColumnWidth(ScenarioModel scenarioModel) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < scenarioModel.parameterNames.size(); ++i) {
            int maxWidth = scenarioModel.parameterNames.get(i).length();
            for (ScenarioCaseModel c : scenarioModel.scenarioCases) {
                int width;
                if (c.arguments.size() <= i || (width = c.arguments.get(i).length()) <= maxWidth) continue;
                maxWidth = width;
            }
            result.add(maxWidth);
        }
        return result;
    }
}

